/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.ProcessApplicationReferenceImpl;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;

public class ServletProcessApplication
extends AbstractProcessApplication
implements ServletContextListener {
    protected String servletContextName;
    protected String servletContextPath;
    protected ProcessApplicationReferenceImpl reference;
    protected ClassLoader processApplicationClassloader;
    protected ServletContext servletContext;

    @Override
    protected String autodetectProcessApplicationName() {
        String name;
        String string = name = this.servletContextName != null && !this.servletContextName.isEmpty() ? this.servletContextName : this.servletContextPath;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    @Override
    public ProcessApplicationReference getReference() {
        if (this.reference == null) {
            this.reference = new ProcessApplicationReferenceImpl(this);
        }
        return this.reference;
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
        this.servletContextPath = this.servletContext.getContextPath();
        this.servletContextName = sce.getServletContext().getServletContextName();
        this.processApplicationClassloader = this.initProcessApplicationClassloader(sce);
        this.deploy();
    }

    protected ClassLoader initProcessApplicationClassloader(ServletContextEvent sce) {
        if (this.isServlet30ApiPresent(sce) && this.getClass().equals(ServletProcessApplication.class)) {
            return ClassLoaderUtil.getServletContextClassloader(sce);
        }
        return ClassLoaderUtil.getClassloader(this.getClass());
    }

    private boolean isServlet30ApiPresent(ServletContextEvent sce) {
        return sce.getServletContext().getMajorVersion() >= 3;
    }

    @Override
    public ClassLoader getProcessApplicationClassloader() {
        return this.processApplicationClassloader;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.undeploy();
        if (this.reference != null) {
            this.reference.clear();
        }
        this.reference = null;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("servletContextPath", this.servletContextPath);
        return properties;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

