/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.history.UserOperationLogContext;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.UserOperationLogQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class UserOperationLogManager
extends AbstractHistoricManager {
    public long findOperationLogEntryCountByQueryCriteria(UserOperationLogQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectUserOperationLogEntryCountByQueryCriteria", query);
    }

    public List<UserOperationLogEntry> findOperationLogEntriesByQueryCriteria(UserOperationLogQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectUserOperationLogEntriesByQueryCriteria", query, page);
    }

    public void deleteOperationLogEntriesByProcessInstanceId(String historicProcessInstanceId) {
        this.getDbSqlSession().delete("deleteUserOperationLogEntriesByProcessInstanceId", historicProcessInstanceId);
    }

    public void deleteOperationLogEntriesByCaseInstanceId(String caseInstanceId) {
        this.getDbSqlSession().delete("deleteUserOperationLogEntriesByCaseInstanceId", caseInstanceId);
    }

    public void deleteOperationLogEntriesByCaseDefinitionId(String caseInstanceId) {
        this.getDbSqlSession().delete("deleteUserOperationLogEntriesByCaseDefinitionId", caseInstanceId);
    }

    public void deleteOperationLogEntriesByTaskId(String taskId) {
        this.getDbSqlSession().delete("deleteUserOperationLogEntriesByTaskId", taskId);
    }

    public void logUserOperations(UserOperationLogContext context) {
        if (this.isHistoryLevelFullEnabled()) {
            ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            List<HistoryEvent> historyEvents = eventProducer.createUserOperationLogEvents(context);
            eventHandler.handleEvents(historyEvents);
        }
    }

    public void logTaskOperations(String operation, TaskEntity task, List<PropertyChange> propertyChanges) {
        if (this.isHistoryLevelFullEnabled()) {
            UserOperationLogContext context = this.createContextForTask("Task", operation, task, propertyChanges);
            this.logUserOperations(context);
        }
    }

    public void logLinkOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            UserOperationLogContext context = this.createContextForTask("IdentityLink", operation, task, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    public void logAttachmentOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isHistoryLevelFullEnabled()) {
            UserOperationLogContext context = this.createContextForTask("Attachment", operation, task, Arrays.asList(propertyChange));
            this.logUserOperations(context);
        }
    }

    protected UserOperationLogContext createContextForTask(String entityType, String operation, TaskEntity task, List<PropertyChange> propertyChanges) {
        UserOperationLogContext context = new UserOperationLogContext();
        context.setEntityType(entityType);
        context.setOperationType(operation);
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(operation)) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        context.setPropertyChanges(propertyChanges);
        context.setProcessDefinitionId(task.getProcessDefinitionId());
        context.setProcessInstanceId(task.getProcessInstanceId());
        context.setExecutionId(task.getExecutionId());
        context.setCaseDefinitionId(task.getCaseDefinitionId());
        context.setCaseInstanceId(task.getCaseInstanceId());
        context.setCaseExecutionId(task.getCaseExecutionId());
        context.setTaskId(task.getId());
        return context;
    }
}

