/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class ExecutionManager
extends AbstractManager {
    public void insertExecution(ExecutionEntity execution) {
        this.getDbSqlSession().insert(execution);
    }

    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List processInstanceIds = this.getDbSqlSession().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            Context.getCommandContext().getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution == null) {
            throw new BadUserRequestException("No process instance found for id '" + processInstanceId + "'");
        }
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getTaskManager().deleteTasksByProcessInstanceId(processInstanceId, deleteReason, cascade);
        execution.deleteCascade(deleteReason);
        if (cascade) {
            commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(processInstanceId);
        }
    }

    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return (ExecutionEntity)this.getDbSqlSession().selectOne("selectSubProcessInstanceBySuperExecutionId", superExecutionId);
    }

    public ExecutionEntity findSubProcessInstanceBySuperCaseExecutionId(String superCaseExecutionId) {
        return (ExecutionEntity)this.getDbSqlSession().selectOne("selectSubProcessInstanceBySuperCaseExecutionId", superCaseExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parentExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectExecutionsByProcessInstanceId", processInstanceId);
    }

    public ExecutionEntity findExecutionById(String executionId) {
        return this.getDbSqlSession().selectById(ExecutionEntity.class, executionId);
    }

    public long findExecutionCountByQueryCriteria(AbstractVariableQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    public List<ExecutionEntity> findExecutionsByQueryCriteria(AbstractVariableQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    public long findProcessInstanceCountByQueryCriteria(AbstractVariableQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessInstanceCountByQueryCriteria", executionQuery);
    }

    public List<ProcessInstance> findProcessInstanceByQueryCriteria(AbstractVariableQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectProcessInstanceByQueryCriteria", executionQuery, page);
    }

    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put("parentExecutionId", parentExecutionId);
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parameters);
    }

    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }

    public void updateExecutionSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateExecutionSuspensionStateByParameters", parameters);
    }

    public void updateExecutionSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateExecutionSuspensionStateByParameters", parameters);
    }

    public void updateExecutionSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateExecutionSuspensionStateByParameters", parameters);
    }
}

