/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Event;

public class CommentEntity
implements Comment,
Event,
PersistentObject,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_EVENT = "event";
    public static final String TYPE_COMMENT = "comment";
    protected String id;
    protected String type;
    protected String userId;
    protected Date time;
    protected String taskId;
    protected String processInstanceId;
    protected String action;
    protected String message;
    protected String fullMessage;
    public static String MESSAGE_PARTS_MARKER = "_|_";

    @Override
    public Object getPersistentState() {
        return CommentEntity.class;
    }

    public byte[] getFullMessageBytes() {
        return this.fullMessage != null ? this.fullMessage.getBytes() : null;
    }

    public void setFullMessageBytes(byte[] fullMessageBytes) {
        this.fullMessage = fullMessageBytes != null ? new String(fullMessageBytes) : null;
    }

    public void setMessage(String[] messageParts) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : messageParts) {
            if (part != null) {
                stringBuilder.append(part.replace(MESSAGE_PARTS_MARKER, " | "));
                stringBuilder.append(MESSAGE_PARTS_MARKER);
                continue;
            }
            stringBuilder.append("null");
            stringBuilder.append(MESSAGE_PARTS_MARKER);
        }
        for (int i = 0; i < MESSAGE_PARTS_MARKER.length(); ++i) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.message = stringBuilder.toString();
    }

    @Override
    public List<String> getMessageParts() {
        if (this.message == null) {
            return null;
        }
        ArrayList<String> messageParts = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.message, MESSAGE_PARTS_MARKER);
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if ("null".equals(nextToken)) {
                messageParts.add(null);
                continue;
            }
            messageParts.add(nextToken);
        }
        return messageParts;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", type=" + this.type + ", userId=" + this.userId + ", time=" + this.time + ", taskId=" + this.taskId + ", processInstanceId=" + this.processInstanceId + ", action=" + this.action + ", message=" + this.message + ", fullMessage=" + this.fullMessage + "]";
    }
}

