/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ibatis.exceptions.PersistenceException;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionManager;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContextCloseListener;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricStatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkManager;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.persistence.entity.StatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.TableDataManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceManager;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CommandContext {
    private static Logger log = Logger.getLogger(CommandContext.class.getName());
    protected Command<?> command;
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception = null;
    protected LinkedList<AtomicOperation> nextOperations = new LinkedList();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FailedJobCommandFactory failedJobCommandFactory;
    protected List<CommandContextCloseListener> commandContextCloseListeners = new LinkedList<CommandContextCloseListener>();

    public CommandContext(Command<?> command, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this(command, processEngineConfiguration, processEngineConfiguration.getTransactionContextFactory());
    }

    public CommandContext(Command<?> cmd, ProcessEngineConfigurationImpl processEngineConfiguration, TransactionContextFactory transactionContextFactory) {
        this.command = cmd;
        this.processEngineConfiguration = processEngineConfiguration;
        this.failedJobCommandFactory = processEngineConfiguration.getFailedJobCommandFactory();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContext = transactionContextFactory.openTransactionContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(final AtomicOperation executionOperation, final ExecutionEntity execution) {
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(execution);
        if (this.requiresContextSwitch(executionOperation, targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CommandContext.this.performOperation(executionOperation, execution);
                    return null;
                }
            }, targetProcessApplication);
        } else {
            this.nextOperations.add(executionOperation);
            if (this.nextOperations.size() == 1) {
                try {
                    Context.setExecutionContext(execution);
                    while (!this.nextOperations.isEmpty()) {
                        AtomicOperation currentOperation = this.nextOperations.removeFirst();
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("AtomicOperation: " + currentOperation + " on " + this);
                        }
                        currentOperation.execute(execution);
                    }
                }
                finally {
                    Context.removeExecutionContext();
                }
            }
        }
    }

    protected ProcessApplicationReference getTargetProcessApplication(ExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    protected boolean requiresContextSwitch(AtomicOperation executionOperation, ProcessApplicationReference processApplicationReference) {
        return ProcessApplicationContextUtil.requiresContextSwitch(processApplicationReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block33: {
            try {
                try {
                    try {
                        if (this.exception == null) {
                            this.fireCommandContextClose();
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block33;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                Level loggingLevel = Level.SEVERE;
                                if (this.shouldLogInfo(this.exception)) {
                                    loggingLevel = Level.INFO;
                                } else if (this.shouldLogFine(this.exception)) {
                                    loggingLevel = Level.FINE;
                                }
                                if (log.isLoggable(loggingLevel)) {
                                    log.log(loggingLevel, "Error while closing command context", this.exception);
                                }
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        Level loggingLevel = Level.SEVERE;
                        if (this.shouldLogInfo(this.exception)) {
                            loggingLevel = Level.INFO;
                        } else if (this.shouldLogFine(this.exception)) {
                            loggingLevel = Level.FINE;
                        }
                        if (log.isLoggable(loggingLevel)) {
                            log.log(loggingLevel, "Error while closing command context", this.exception);
                        }
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof PersistenceException) {
            throw new ProcessEngineException("Process engine persistence exception", this.exception);
        }
        if (!(this.exception instanceof RuntimeException)) throw new ProcessEngineException("exception while executing command " + this.command, this.exception);
        throw (RuntimeException)this.exception;
    }

    protected boolean shouldLogInfo(Throwable exception) {
        return exception instanceof TaskAlreadyClaimedException;
    }

    protected boolean shouldLogFine(Throwable exception) {
        return exception instanceof OptimisticLockingException || exception instanceof BadUserRequestException;
    }

    protected void fireCommandContextClose() {
        for (CommandContextCloseListener listener : this.commandContextCloseListeners) {
            listener.onCommandContextClose(this);
        }
    }

    protected void flushSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>(this.sessions.values());
        for (Session session : sessions) {
            session.flush();
        }
    }

    protected void closeSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>(this.sessions.values());
        for (Session session : sessions) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            log.log(Level.SEVERE, "masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            EnsureUtil.ensureNotNull("no session factory configured for " + sessionClass.getName(), "sessionFactory", (Object)sessionFactory);
            session = sessionFactory.openSession();
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public DeploymentManager getDeploymentManager() {
        return this.getSession(DeploymentManager.class);
    }

    public ResourceManager getResourceManager() {
        return this.getSession(ResourceManager.class);
    }

    public ByteArrayManager getByteArrayManager() {
        return this.getSession(ByteArrayManager.class);
    }

    public ProcessDefinitionManager getProcessDefinitionManager() {
        return this.getSession(ProcessDefinitionManager.class);
    }

    public ExecutionManager getExecutionManager() {
        return this.getSession(ExecutionManager.class);
    }

    public TaskManager getTaskManager() {
        return this.getSession(TaskManager.class);
    }

    public IdentityLinkManager getIdentityLinkManager() {
        return this.getSession(IdentityLinkManager.class);
    }

    public VariableInstanceManager getVariableInstanceManager() {
        return this.getSession(VariableInstanceManager.class);
    }

    public HistoricProcessInstanceManager getHistoricProcessInstanceManager() {
        return this.getSession(HistoricProcessInstanceManager.class);
    }

    public HistoricDetailManager getHistoricDetailManager() {
        return this.getSession(HistoricDetailManager.class);
    }

    public UserOperationLogManager getOperationLogManager() {
        return this.getSession(UserOperationLogManager.class);
    }

    public HistoricVariableInstanceManager getHistoricVariableInstanceManager() {
        return this.getSession(HistoricVariableInstanceManager.class);
    }

    public HistoricActivityInstanceManager getHistoricActivityInstanceManager() {
        return this.getSession(HistoricActivityInstanceManager.class);
    }

    public HistoricTaskInstanceManager getHistoricTaskInstanceManager() {
        return this.getSession(HistoricTaskInstanceManager.class);
    }

    public HistoricIncidentManager getHistoricIncidentManager() {
        return this.getSession(HistoricIncidentManager.class);
    }

    public JobManager getJobManager() {
        return this.getSession(JobManager.class);
    }

    public JobDefinitionManager getJobDefinitionManager() {
        return this.getSession(JobDefinitionManager.class);
    }

    public IncidentManager getIncidentManager() {
        return this.getSession(IncidentManager.class);
    }

    public IdentityInfoManager getIdentityInfoManager() {
        return this.getSession(IdentityInfoManager.class);
    }

    public AttachmentManager getAttachmentManager() {
        return this.getSession(AttachmentManager.class);
    }

    public TableDataManager getTableDataManager() {
        return this.getSession(TableDataManager.class);
    }

    public CommentManager getCommentManager() {
        return this.getSession(CommentManager.class);
    }

    public EventSubscriptionManager getEventSubscriptionManager() {
        return this.getSession(EventSubscriptionManager.class);
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public PropertyManager getPropertyManager() {
        return this.getSession(PropertyManager.class);
    }

    public StatisticsManager getStatisticsManager() {
        return this.getSession(StatisticsManager.class);
    }

    public HistoricStatisticsManager getHistoricStatisticsManager() {
        return this.getSession(HistoricStatisticsManager.class);
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.getSession(AuthorizationManager.class);
    }

    public ReadOnlyIdentityProvider getReadOnlyIdentityProvider() {
        return this.getSession(ReadOnlyIdentityProvider.class);
    }

    public WritableIdentityProvider getWritableIdentityProvider() {
        return this.getSession(WritableIdentityProvider.class);
    }

    public CaseDefinitionManager getCaseDefinitionManager() {
        return this.getSession(CaseDefinitionManager.class);
    }

    public CaseExecutionManager getCaseExecutionManager() {
        return this.getSession(CaseExecutionManager.class);
    }

    public void registerCommandContextCloseListener(CommandContextCloseListener commandContextCloseListener) {
        if (!this.commandContextCloseListeners.contains(commandContextCloseListener)) {
            this.commandContextCloseListeners.add(commandContextCloseListener);
        }
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }

    public Authentication getAuthentication() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        return identityService.getCurrentAuthentication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutAuthentication(Runnable runnable) {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            runnable.run();
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
    }

    public String getAuthenticatedUserId() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getUserId();
    }

    public List<String> getAuthenticatedGroupIds() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getGroupIds();
    }
}

