/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.operation;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.operation.AbstractCmmnEventAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.PvmException;

public class AtomicOperationCaseExecutionDisable
extends AbstractCmmnEventAtomicOperation {
    @Override
    public String getCanonicalName() {
        return "case-execution-disable";
    }

    @Override
    protected String getEventName() {
        return "disable";
    }

    @Override
    protected CmmnExecution eventNotificationsStarted(CmmnExecution execution) {
        try {
            CmmnActivityBehavior behavior = this.getActivityBehavior(execution);
            behavior.onDisable(execution);
            execution.setCurrentState(CaseExecutionState.DISABLED);
        }
        catch (RuntimeException e) {
            String id = execution.getId();
            throw new PvmException("Cannot disable case execution '" + id + "'.", e);
        }
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(CmmnExecution execution) {
        CmmnActivityBehavior behavior;
        CmmnExecution parent = execution.getParent();
        if (parent != null && (behavior = this.getActivityBehavior(parent)) instanceof CompositeActivityBehavior) {
            CompositeActivityBehavior compositeBehavior = (CompositeActivityBehavior)behavior;
            compositeBehavior.childStateChanged(parent, execution);
        }
    }
}

