/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cmmn.behavior.CallableElement;
import org.camunda.bpm.engine.impl.cmmn.behavior.CallableElementParameter;
import org.camunda.bpm.engine.impl.cmmn.behavior.ProcessOrCaseTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.TaskPlanItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.core.mapping.value.ConstantValueProvider;
import org.camunda.bpm.engine.impl.core.mapping.value.NullValueProvider;
import org.camunda.bpm.engine.impl.core.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.model.cmmn.Query;
import org.camunda.bpm.model.cmmn.instance.ExtensionElements;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaOut;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class ProcessOrCaseTaskPlanItemHandler
extends TaskPlanItemHandler {
    @Override
    protected void initializeActivity(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeActivity(planItem, activity, context);
        this.initializeCallableElement(planItem, activity, context);
    }

    protected void initializeCallableElement(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        CallableElement callableElement = new CallableElement();
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        behavior.setCallableElement(callableElement);
        this.initializeDefinitionKey(planItem, activity, context, callableElement);
        this.initializeBinding(planItem, activity, context, callableElement);
        this.initializeVersion(planItem, activity, context, callableElement);
        this.initializeInputParameter(planItem, activity, context);
        this.initializeOutputParameter(planItem, activity, context);
    }

    protected void initializeDefinitionKey(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String definitionKey = this.getDefinitionKey(planItem, activity, context);
        ParameterValueProvider definitionKeyProvider = this.createParameterValueProvider(definitionKey, expressionManager);
        callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
    }

    protected void initializeBinding(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        String binding = this.getBinding(planItem, activity, context);
        if (CallableElement.CallableElementBinding.DEPLOYMENT.getValue().equals(binding)) {
            callableElement.setBinding(CallableElement.CallableElementBinding.DEPLOYMENT);
        } else if (CallableElement.CallableElementBinding.LATEST.getValue().equals(binding)) {
            callableElement.setBinding(CallableElement.CallableElementBinding.LATEST);
        } else if (CallableElement.CallableElementBinding.VERSION.getValue().equals(binding)) {
            callableElement.setBinding(CallableElement.CallableElementBinding.VERSION);
        }
    }

    protected void initializeVersion(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String version = this.getVersion(planItem, activity, context);
        ParameterValueProvider versionProvider = this.createParameterValueProvider(version, expressionManager);
        callableElement.setVersionValueProvider(versionProvider);
    }

    protected void initializeInputParameter(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ExpressionManager expressionManager = context.getExpressionManager();
        List<CamundaIn> inputs = this.getInputs(planItem);
        for (CamundaIn input : inputs) {
            String businessKey = input.getCamundaBusinessKey();
            if (businessKey != null && !businessKey.isEmpty()) {
                ParameterValueProvider businessKeyValueProvider = this.createParameterValueProvider(businessKey, expressionManager);
                callableElement.setBusinessKeyValueProvider(businessKeyValueProvider);
                continue;
            }
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addInput(parameter);
            String variables = input.getCamundaVariables();
            if ("all".equals(variables)) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = input.getCamundaSource();
            if (source == null || source.isEmpty()) {
                source = input.getCamundaSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = input.getCamundaTarget();
            parameter.setTarget(target);
        }
    }

    protected void initializeOutputParameter(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ExpressionManager expressionManager = context.getExpressionManager();
        List<CamundaOut> outputs = this.getOutputs(planItem);
        for (CamundaOut output : outputs) {
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addOutput(parameter);
            String variables = output.getCamundaVariables();
            if ("all".equals(variables)) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = output.getCamundaSource();
            if (source == null || source.isEmpty()) {
                source = output.getCamundaSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = output.getCamundaTarget();
            parameter.setTarget(target);
        }
    }

    protected List<CamundaIn> getInputs(PlanItem planItem) {
        return this.getParameter(planItem, CamundaIn.class);
    }

    protected List<CamundaOut> getOutputs(PlanItem planItem) {
        return this.getParameter(planItem, CamundaOut.class);
    }

    protected <T extends ModelElementInstance> List<T> getParameter(PlanItem planItem, Class<T> cls) {
        PlanItemDefinition definition = this.getDefinition(planItem);
        ExtensionElements extensionElements = definition.getExtensionElements();
        if (extensionElements != null) {
            Query query = extensionElements.getElementsQuery();
            return query.filterByType(cls).list();
        }
        return new ArrayList();
    }

    protected ParameterValueProvider createParameterValueProvider(String value, ExpressionManager expressionManager) {
        if (value == null) {
            return new NullValueProvider();
        }
        if (StringUtil.isExpression(value)) {
            Expression expression = expressionManager.createExpression(value);
            return new ElValueProvider(expression);
        }
        return new ConstantValueProvider(value);
    }

    protected abstract String getDefinitionKey(PlanItem var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getBinding(PlanItem var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getVersion(PlanItem var1, CmmnActivity var2, CmmnHandlerContext var3);
}

