/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cmmn.behavior.CaseControlRuleImpl;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.model.cmmn.impl.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.ManualActivationRule;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.RepetitionRule;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;

public abstract class PlanItemHandler
extends CmmnElementHandler<PlanItem> {
    @Override
    public CmmnActivity handleElement(PlanItem planItem, CmmnHandlerContext context) {
        CmmnActivity newActivity = this.createActivity((CmmnElement)planItem, context);
        this.initializeActivity(planItem, newActivity, context);
        return newActivity;
    }

    @Override
    protected void initializeActivity(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        String name = planItem.getName();
        if (name == null) {
            PlanItemDefinition definition = planItem.getDefinition();
            name = definition.getName();
        }
        activity.setName(name);
        this.initializeRequiredRule(planItem, activity, context);
        this.initializeManualActivationRule(planItem, activity, context);
        this.initializeRepetitionRule(planItem, activity, context);
    }

    protected void initializeRequiredRule(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition = planItem.getDefinition();
        PlanItemControl itemControl = planItem.getItemControl();
        DefaultControl defaultControl = definition.getDefaultControl();
        ExpressionManager expressionManager = context.getExpressionManager();
        RequiredRule requiredRule = null;
        if (itemControl != null) {
            requiredRule = itemControl.getRequiredRule();
        }
        if (requiredRule == null && defaultControl != null) {
            requiredRule = defaultControl.getRequiredRule();
        }
        if (requiredRule != null) {
            String rule = requiredRule.getCondition().getBody();
            Expression requiredRuleExpression = expressionManager.createExpression(rule);
            CaseControlRuleImpl caseRule = new CaseControlRuleImpl(requiredRuleExpression);
            activity.setProperty("requiredRule", caseRule);
        }
    }

    protected void initializeManualActivationRule(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition = planItem.getDefinition();
        PlanItemControl itemControl = planItem.getItemControl();
        DefaultControl defaultControl = definition.getDefaultControl();
        ExpressionManager expressionManager = context.getExpressionManager();
        ManualActivationRule manualActivationRule = null;
        if (itemControl != null) {
            manualActivationRule = itemControl.getManualActivationRule();
        }
        if (manualActivationRule == null && defaultControl != null) {
            manualActivationRule = defaultControl.getManualActivationRule();
        }
        if (manualActivationRule != null) {
            String rule = manualActivationRule.getCondition().getBody();
            Expression requiredRuleExpression = expressionManager.createExpression(rule);
            CaseControlRuleImpl caseRule = new CaseControlRuleImpl(requiredRuleExpression);
            activity.setProperty("manualActivationRule", caseRule);
        }
    }

    protected void initializeRepetitionRule(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition = planItem.getDefinition();
        PlanItemControl itemControl = planItem.getItemControl();
        DefaultControl defaultControl = definition.getDefaultControl();
        ExpressionManager expressionManager = context.getExpressionManager();
        RepetitionRule repetitionRule = null;
        if (itemControl != null) {
            repetitionRule = itemControl.getRepetitionRule();
        }
        if (repetitionRule == null && defaultControl != null) {
            repetitionRule = defaultControl.getRepetitionRule();
        }
        if (repetitionRule != null) {
            String rule = repetitionRule.getCondition().getBody();
            Expression requiredRuleExpression = expressionManager.createExpression(rule);
            CaseControlRuleImpl caseRule = new CaseControlRuleImpl(requiredRuleExpression);
            activity.setProperty("repetitionRule", caseRule);
        }
    }

    protected PlanItemDefinition getDefinition(PlanItem planItem) {
        return planItem.getDefinition();
    }

    protected String getDesciption(PlanItem planItem) {
        String description = planItem.getDescription();
        if (description == null) {
            PlanItemDefinition definition = this.getDefinition(planItem);
            description = definition.getDescription();
        }
        return description;
    }
}

