/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import java.util.List;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.HumanTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.TaskPlanItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.form.handler.DefaultTaskFormHandler;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.Role;

public class HumanTaskPlanItemHandler
extends TaskPlanItemHandler {
    @Override
    public CmmnActivity handleElement(PlanItem planItem, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        if (!definition.isBlocking()) {
            return null;
        }
        return super.handleElement(planItem, context);
    }

    @Override
    protected void initializeActivity(PlanItem planItem, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeActivity(planItem, activity, context);
        TaskDefinition taskDefinition = this.createTaskDefinition(planItem, context);
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)context.getCaseDefinition();
        caseDefinition.getTaskDefinitions().put(taskDefinition.getKey(), taskDefinition);
        ExpressionManager expressionManager = context.getExpressionManager();
        TaskDecorator taskDecorator = new TaskDecorator(taskDefinition, expressionManager);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        behavior.setTaskDecorator(taskDecorator);
    }

    protected TaskDefinition createTaskDefinition(PlanItem planItem, CmmnHandlerContext context) {
        DefaultTaskFormHandler taskFormHandler = new DefaultTaskFormHandler();
        TaskDefinition taskDefinition = new TaskDefinition(taskFormHandler);
        String taskDefinitionKey = planItem.getId();
        taskDefinition.setKey(taskDefinitionKey);
        this.initializeTaskDefinitionName(planItem, taskDefinition, context);
        this.initializeTaskDefinitionDueDate(planItem, taskDefinition, context);
        this.initializeTaskDefinitionPriority(planItem, taskDefinition, context);
        this.initializeTaskDefinitionAssignee(planItem, taskDefinition, context);
        this.initializeTaskDefinitionCandidateUsers(planItem, taskDefinition, context);
        this.initializeTaskDefinitionCandidateGroups(planItem, taskDefinition, context);
        this.initializeTaskDefinitionFormKey(planItem, taskDefinition, context);
        this.initializeTaskDescription(planItem, taskDefinition, context);
        return taskDefinition;
    }

    protected void initializeTaskDefinitionName(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        String name = planItem.getName();
        if (name == null) {
            HumanTask definition = this.getDefinition(planItem);
            name = definition.getName();
        }
        if (name != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression nameExpression = expressionManager.createExpression(name);
            taskDefinition.setNameExpression(nameExpression);
        }
    }

    protected void initializeTaskDefinitionFormKey(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        String formKey = definition.getCamundaFormKey();
        if (formKey != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression formKeyExpression = expressionManager.createExpression(formKey);
            taskDefinition.setFormKey(formKeyExpression);
        }
    }

    protected void initializeTaskDefinitionAssignee(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        Role performer = definition.getPerformer();
        String assignee = null;
        assignee = performer != null ? performer.getName() : definition.getCamundaAssignee();
        if (assignee != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression assigneeExpression = expressionManager.createExpression(assignee);
            taskDefinition.setAssigneeExpression(assigneeExpression);
        }
    }

    protected void initializeTaskDefinitionCandidateUsers(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        ExpressionManager expressionManager = context.getExpressionManager();
        List candidateUsers = definition.getCamundaCandidateUsersList();
        for (String candidateUser : candidateUsers) {
            Expression candidateUserExpression = expressionManager.createExpression(candidateUser);
            taskDefinition.addCandidateUserIdExpression(candidateUserExpression);
        }
    }

    protected void initializeTaskDefinitionCandidateGroups(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        ExpressionManager expressionManager = context.getExpressionManager();
        List candidateGroups = definition.getCamundaCandidateGroupsList();
        for (String candidateGroup : candidateGroups) {
            Expression candidateGroupExpression = expressionManager.createExpression(candidateGroup);
            taskDefinition.addCandidateGroupIdExpression(candidateGroupExpression);
        }
    }

    protected void initializeTaskDefinitionDueDate(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        String dueDate = definition.getCamundaDueDate();
        if (dueDate != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression dueDateExpression = expressionManager.createExpression(dueDate);
            taskDefinition.setDueDateExpression(dueDateExpression);
        }
    }

    protected void initializeTaskDefinitionPriority(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        HumanTask definition = this.getDefinition(planItem);
        String priority = definition.getCamundaPriority();
        if (priority != null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression priorityExpression = expressionManager.createExpression(priority);
            taskDefinition.setPriorityExpression(priorityExpression);
        }
    }

    protected void initializeTaskDescription(PlanItem planItem, TaskDefinition taskDefinition, CmmnHandlerContext context) {
        String description = this.getDesciption(planItem);
        if (description != null && !description.isEmpty()) {
            ExpressionManager expressionManager = context.getExpressionManager();
            Expression descriptionExpression = expressionManager.createExpression(description);
            taskDefinition.setDescriptionExpression(descriptionExpression);
        }
    }

    protected HumanTask getDefinition(PlanItem planItem) {
        return (HumanTask)planItem.getDefinition();
    }

    @Override
    protected CmmnActivityBehavior getActivityBehavior() {
        return new HumanTaskActivityBehavior();
    }
}

