/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.behavior.PlanItemDefinitionActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;

public abstract class EventListenerOrMilestoneActivityBehavior
extends PlanItemDefinitionActivityBehavior {
    @Override
    public void onEnable(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition enable on a event listener or a milestone.");
    }

    @Override
    public void onReenable(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition re-enable on a event listener or a milestone.");
    }

    @Override
    public void onDisable(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition disable on a event listener or a milestone.");
    }

    @Override
    public void onStart(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition start on a event listener or a milestone.");
    }

    @Override
    public void onManualStart(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition manualStart on a event listener or a milestone.");
    }

    @Override
    public void started(CmmnActivityExecution execution) throws Exception {
        throw new UnsupportedOperationException("It is not possible to execute the started behavior of a event listener or a milestone.");
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition complete on a event listener or a milestone.");
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition complete on a event listener or a milestone.");
    }

    @Override
    public void onTermination(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.TERMINATED, "terminate");
        this.terminating(execution);
    }

    @Override
    public void onParentTermination(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isTerminated()) {
            throw new ProcessEngineException("Case execution '" + id + "' is already terminated.");
        }
        if (execution.isCompleted()) {
            String message = "Case execution '" + id + "' must be available or suspended to parentTerminate it, but was completed.";
            throw new ProcessEngineException(message);
        }
        this.terminating(execution);
    }

    @Override
    public void onExit(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition exit on a event listener or a milestone.");
    }

    @Override
    public void onOccur(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.COMPLETED, "occur");
    }

    @Override
    public void onSuspension(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.SUSPENDED, "suspend");
        this.suspending(execution);
    }

    @Override
    public void onParentSuspension(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition parentSuspend on a event listener or a milestone.");
    }

    @Override
    public void onResume(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.SUSPENDED, CaseExecutionState.AVAILABLE, "resume");
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            throw new ProcessEngineException("It is not possible to resume a case execution which parent is not active.");
        }
        this.resuming(execution);
    }

    @Override
    public void onParentResume(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition parentResume on a event listener or a milestone.");
    }

    @Override
    public void onReactivation(CmmnActivityExecution execution) {
        throw new UnsupportedOperationException("It is not possible to execute the transition re-activate on a event listener or a milestone.");
    }
}

