/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;

public class GetTaskFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    public GetTaskFormVariablesCmd(String taskId, Collection<String> variableNames) {
        super(taskId, variableNames);
    }

    @Override
    public Map<String, VariableInstance> execute(CommandContext commandContext) {
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.resourceId);
        if (task == null) {
            throw new BadUserRequestException("Cannot find task with id '" + this.resourceId + "'.");
        }
        HashMap<String, VariableInstance> result = new HashMap<String, VariableInstance>();
        TaskFormData taskFormData = task.getTaskDefinition().getTaskFormHandler().createTaskForm(task);
        for (FormField formField : taskFormData.getFormFields()) {
            if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
            result.put(formField.getId(), this.createVariable(formField));
        }
        task.collectVariableInstances(result, this.formVariableNames);
        return result;
    }
}

