/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CorrelateMessageCmd
extends AbstractCorrelateMessageCmd {
    public CorrelateMessageCmd(String messageName, String businessKey, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        super(messageName, businessKey, correlationKeys, processVariables);
    }

    public CorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        super(messageCorrelationBuilderImpl);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("messageName", (Object)this.messageName);
        CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        CorrelationSet correlationSet = new CorrelationSet(this.businessKey, this.processInstanceId, this.correlationKeys);
        MessageCorrelationResult correlationResult = correlationHandler.correlateMessage(commandContext, this.messageName, correlationSet);
        if (correlationResult == null) {
            throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
        }
        if ("execution".equals(correlationResult.getResultType())) {
            this.triggerExecution(commandContext, correlationResult);
        } else {
            this.instantiateProcess(commandContext, correlationResult);
        }
        return null;
    }
}

