/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.query.QueryProperty;

public abstract class AbstractQuery<T extends Query<?, ?>, U>
extends ListQueryParameterObject
implements Command<Object>,
Query<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SORTORDER_ASC = "asc";
    public static final String SORTORDER_DESC = "desc";
    protected transient CommandExecutor commandExecutor;
    protected transient CommandContext commandContext;
    protected String orderBy;
    protected ResultType resultType;
    protected QueryProperty orderProperty;

    protected AbstractQuery() {
    }

    protected AbstractQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AbstractQuery(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public AbstractQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public T orderBy(QueryProperty property) {
        this.orderProperty = property;
        return (T)this;
    }

    @Override
    public T asc() {
        return this.direction(Direction.ASCENDING);
    }

    @Override
    public T desc() {
        return this.direction(Direction.DESCENDING);
    }

    public T direction(Direction direction) {
        EnsureUtil.ensureNotNull("You should call any of the orderBy methods first before specifying a direction", "orderProperty", (Object)this.orderProperty);
        this.addOrder(this.orderProperty.getName(), direction.getName());
        this.orderProperty = null;
        return (T)this;
    }

    protected void checkQueryOk() {
        if (this.orderProperty != null) {
            throw new ProcessEngineException("Invalid query: call asc() or desc() after using orderByXX()");
        }
    }

    @Override
    public U singleResult() {
        this.resultType = ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute(this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    @Override
    public List<U> list() {
        this.resultType = ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeList(Context.getCommandContext(), null);
    }

    @Override
    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeList(Context.getCommandContext(), new Page(firstResult, maxResults));
    }

    @Override
    public long count() {
        this.resultType = ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute(this);
        }
        return this.executeCount(Context.getCommandContext());
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.resultType == ResultType.LIST) {
            return this.executeList(commandContext, null);
        }
        if (this.resultType == ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        if (this.resultType == ResultType.LIST_PAGE) {
            return this.executeList(commandContext, null);
        }
        return this.executeCount(commandContext);
    }

    public abstract long executeCount(CommandContext var1);

    public abstract List<U> executeList(CommandContext var1, Page var2);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.executeList(commandContext, null);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new ProcessEngineException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }

    protected void addOrder(String column, String sortOrder) {
        this.orderBy = this.orderBy == null ? "" : this.orderBy + ", ";
        this.orderBy = this.orderBy + column + " " + sortOrder;
    }

    @Override
    public String getOrderBy() {
        if (this.orderBy == null) {
            return super.getOrderBy();
        }
        return this.orderBy;
    }

    private static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

