/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.metadata;

import java.lang.reflect.Method;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class PropertyHelper {
    public static boolean getBooleanProperty(Map<String, String> properties, String name, boolean defaultValue) {
        String value = properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static Object convertToClass(String value, Class<?> clazz) {
        Object propertyValue = clazz.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(Integer.parseInt(value)) : (clazz.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(Boolean.parseBoolean(value)) : value);
        return propertyValue;
    }

    public static void applyProperty(Object configuration, String key, String stringValue) {
        Class<?> configurationClass = configuration.getClass();
        Method setter = ReflectUtil.getSingleSetter(key, configurationClass);
        if (setter != null) {
            try {
                Class<?> parameterClass = setter.getParameterTypes()[0];
                Object value = PropertyHelper.convertToClass(stringValue, parameterClass);
                setter.invoke(configuration, value);
            }
            catch (Exception e) {
                throw new ProcessEngineException("Could not set value for property '" + key + "' on class " + configurationClass.getCanonicalName(), e);
            }
        } else {
            throw new ProcessEngineException("Could not find setter for property '" + key + "' on class " + configurationClass.getCanonicalName());
        }
    }

    public static void applyProperties(Object configuration, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            PropertyHelper.applyProperty(configuration, property.getKey(), property.getValue());
        }
    }
}

