/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util.io;

import java.io.InputStream;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.util.io.StreamSource;

public class ResourceStreamSource
implements StreamSource {
    String resource;
    ClassLoader classLoader;

    public ResourceStreamSource(String resource) {
        this.resource = resource;
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        this.resource = resource;
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getInputStream() {
        InputStream inputStream = null;
        if (this.classLoader == null) {
            inputStream = ReflectUtil.getResourceAsStream(this.resource);
        } else {
            this.classLoader.getResourceAsStream(this.resource);
        }
        if (inputStream == null) {
            throw new ProcessEngineException("resource '" + this.resource + "' doesn't exist");
        }
        return inputStream;
    }

    public String toString() {
        return "Resource[" + this.resource + "]";
    }
}

