/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting.engine;

import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.scripting.engine.Resolver;

public class VariableScopeResolver
implements Resolver {
    protected VariableScope variableScope;
    protected String variableScopeKey = "execution";

    public VariableScopeResolver(VariableScope variableScope) {
        if (variableScope == null) {
            throw new ProcessEngineException("variableScope cannot be null");
        }
        if (variableScope instanceof ExecutionEntity) {
            this.variableScopeKey = "execution";
        } else if (variableScope instanceof TaskEntity) {
            this.variableScopeKey = "task";
        } else {
            throw new ProcessEngineException("unsupported variable scope type: " + variableScope.getClass().getName());
        }
        this.variableScope = variableScope;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.variableScopeKey.equals(key) || this.variableScope.hasVariable((String)key);
    }

    @Override
    public Object get(Object key) {
        if (this.variableScopeKey.equals(key)) {
            return this.variableScope;
        }
        return this.variableScope.getVariable((String)key);
    }

    @Override
    public Set<String> keySet() {
        Set<String> variableNames = this.variableScope.getVariableNames();
        variableNames.add(this.variableScopeKey);
        return variableNames;
    }
}

