/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationTransitionCreateScope
implements PvmAtomicOperation {
    private static Logger log = Logger.getLogger(PvmAtomicOperationTransitionCreateScope.class.getName());

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        return activity.isAsync();
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        execution.setActivityInstanceId(execution.getParentActivityInstanceId());
        PvmExecutionImpl propagatingExecution = null;
        ActivityImpl activity = execution.getActivity();
        if (activity.isScope()) {
            propagatingExecution = execution.createExecution();
            propagatingExecution.setActivity(activity);
            propagatingExecution.setTransition(execution.getTransition());
            execution.setTransition(null);
            execution.setActive(false);
            execution.setActivity(null);
            log.fine("create scope: parent " + execution + " continues as execution " + propagatingExecution);
            propagatingExecution.initialize();
        } else {
            propagatingExecution = execution;
        }
        propagatingExecution.performOperation(TRANSITION_NOTIFY_LISTENER_START);
    }

    @Override
    public String getCanonicalName() {
        return "transition-create-scope";
    }
}

