/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.delegate.TaskListenerInvocation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextCloseListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntityVariableStore;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.variable.AbstractVariableStore;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class TaskEntity
extends CoreVariableScope
implements Task,
DelegateTask,
Serializable,
PersistentObject,
HasRevision,
CommandContextCloseListener {
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String owner;
    protected String assignee;
    protected DelegationState delegationState;
    protected String parentTaskId;
    protected String name;
    protected String description;
    protected int priority = 50;
    protected Date createTime;
    protected Date dueDate;
    protected Date followUpDate;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected boolean isIdentityLinksInitialized = false;
    protected transient List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String executionId;
    protected transient ExecutionEntity execution;
    protected String processInstanceId;
    protected transient ExecutionEntity processInstance;
    protected String processDefinitionId;
    protected transient TaskDefinition taskDefinition;
    protected String taskDefinitionKey;
    protected boolean isDeleted;
    protected String deleteReason;
    protected String eventName;
    protected AbstractVariableStore variableStore;
    private transient Map<String, PropertyChange> propertyChanges = new HashMap<String, PropertyChange>();
    public static final String ASSIGNEE = "assignee";
    public static final String DELEGATION = "delegation";
    public static final String DELETE = "delete";
    public static final String DESCRIPTION = "description";
    public static final String DUE_DATE = "dueDate";
    public static final String FOLLOW_UP_DATE = "followUpDate";
    public static final String NAME = "name";
    public static final String OWNER = "owner";
    public static final String PARENT_TASK = "parentTask";
    public static final String PRIORITY = "priority";

    public TaskEntity() {
        this(null);
    }

    public TaskEntity(String taskId) {
        this.id = taskId;
        this.variableStore = this.createVariableStore();
    }

    public static TaskEntity createAndInsert(ActivityExecution execution) {
        TaskEntity task = TaskEntity.create();
        task.insert((ExecutionEntity)execution);
        return task;
    }

    public void insert(ExecutionEntity execution) {
        this.ensureParentTaskActive();
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.insert(this);
        if (execution != null) {
            execution.addTask(this);
        }
    }

    public void update() {
        this.setAssignee(this.getAssignee());
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update(this);
        commandContext.registerCommandContextCloseListener(this);
    }

    public static TaskEntity create() {
        TaskEntity task = new TaskEntity();
        task.isIdentityLinksInitialized = true;
        task.setCreateTime(ClockUtil.getCurrentTime());
        return task;
    }

    public void complete() {
        this.ensureTaskActive();
        this.fireEvent("complete");
        Context.getCommandContext().getTaskManager().deleteTask(this, DELETE_REASON_COMPLETED, false);
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            execution.removeTask(this);
            execution.signal(null, null);
        }
    }

    public void delete(String deleteReason, boolean cascade) {
        this.deleteReason = deleteReason;
        this.fireEvent(DELETE);
        Context.getCommandContext().getTaskManager().deleteTask(this, deleteReason, cascade);
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            execution.removeTask(this);
        }
    }

    @Override
    public void delegate(String userId) {
        this.setDelegationState(DelegationState.PENDING);
        if (this.getOwner() == null) {
            this.setOwner(this.getAssignee());
        }
        this.setAssignee(userId);
    }

    public void resolve() {
        this.setDelegationState(DelegationState.RESOLVED);
        this.setAssignee(this.owner);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put(ASSIGNEE, this.assignee);
        persistentState.put(OWNER, this.owner);
        persistentState.put(NAME, this.name);
        persistentState.put(PRIORITY, this.priority);
        if (this.executionId != null) {
            persistentState.put("executionId", this.executionId);
        }
        if (this.processDefinitionId != null) {
            persistentState.put("processDefinitionId", this.processDefinitionId);
        }
        if (this.createTime != null) {
            persistentState.put("createTime", this.createTime);
        }
        if (this.description != null) {
            persistentState.put(DESCRIPTION, this.description);
        }
        if (this.dueDate != null) {
            persistentState.put(DUE_DATE, this.dueDate);
        }
        if (this.followUpDate != null) {
            persistentState.put(FOLLOW_UP_DATE, this.followUpDate);
        }
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.delegationState != null) {
            persistentState.put("delegationState", (Object)this.delegationState);
        }
        persistentState.put("suspensionState", this.suspensionState);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    protected void ensureParentTaskActive() {
        if (this.parentTaskId != null) {
            TaskEntity parentTask = Context.getCommandContext().getTaskManager().findTaskById(this.parentTaskId);
            if (parentTask.suspensionState == SuspensionState.SUSPENDED.getStateCode()) {
                throw new SuspendedEntityInteractionException("parent task " + this.id + " is suspended");
            }
        }
    }

    protected void ensureTaskActive() {
        if (this.suspensionState == SuspensionState.SUSPENDED.getStateCode()) {
            throw new SuspendedEntityInteractionException("task " + this.id + " is suspended");
        }
    }

    @Override
    public UserTask getBpmnModelElementInstance() {
        BpmnModelInstance bpmnModelInstance = this.getBpmnModelInstance();
        if (bpmnModelInstance != null) {
            ModelElementInstance modelElementInstance = bpmnModelInstance.getModelElementById(this.taskDefinitionKey);
            try {
                return (UserTask)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw new ProcessEngineException("Cannot cast " + modelElementInstance + " to UserTask. " + "Is of type " + elementType.getTypeName() + " Namespace " + elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance() {
        if (this.processDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        }
        return null;
    }

    protected AbstractVariableStore createVariableStore() {
        return new TaskEntityVariableStore(this);
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStore;
    }

    @Override
    public CoreVariableScope getParentVariableScope() {
        if (this.getExecution() != null) {
            return this.execution;
        }
        return null;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setTaskId(this.id);
        variableInstance.setExecutionId(this.executionId);
        variableInstance.setProcessInstanceId(this.processInstanceId);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByTaskId(this.id);
    }

    @Override
    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(DelegateExecution execution) {
        if (execution != null) {
            this.execution = (ExecutionEntity)execution;
            this.executionId = this.execution.getId();
            this.processInstanceId = this.execution.getProcessInstanceId();
            this.processDefinitionId = this.execution.getProcessDefinitionId();
        } else {
            this.execution = null;
            this.executionId = null;
            this.processInstanceId = null;
            this.processDefinitionId = null;
        }
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId, String type) {
        this.ensureTaskActive();
        IdentityLinkEntity identityLinkEntity = IdentityLinkEntity.createAndInsert();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setTask(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId, String type) {
        this.ensureTaskActive();
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkManager().findIdentityLinkByTaskUserGroupAndType(this.id, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            Context.getCommandContext().getDbSqlSession().delete(identityLink);
        }
    }

    @Override
    public Set<IdentityLink> getCandidates() {
        HashSet<IdentityLink> potentialOwners = new HashSet<IdentityLink>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType())) continue;
            potentialOwners.add(identityLinkEntity);
        }
        return potentialOwners;
    }

    @Override
    public void addCandidateUser(String userId) {
        this.addIdentityLink(userId, null, "candidate");
    }

    @Override
    public void addCandidateUsers(Collection<String> candidateUsers) {
        for (String candidateUser : candidateUsers) {
            this.addCandidateUser(candidateUser);
        }
    }

    @Override
    public void addCandidateGroup(String groupId) {
        this.addIdentityLink(null, groupId, "candidate");
    }

    @Override
    public void addCandidateGroups(Collection<String> candidateGroups) {
        for (String candidateGroup : candidateGroups) {
            this.addCandidateGroup(candidateGroup);
        }
    }

    @Override
    public void addGroupIdentityLink(String groupId, String identityLinkType) {
        this.addIdentityLink(null, groupId, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(String userId, String identityLinkType) {
        this.addIdentityLink(userId, null, identityLinkType);
    }

    @Override
    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    @Override
    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    @Override
    public void deleteGroupIdentityLink(String groupId, String identityLinkType) {
        if (groupId != null) {
            this.deleteIdentityLink(null, groupId, identityLinkType);
        }
    }

    @Override
    public void deleteUserIdentityLink(String userId, String identityLinkType) {
        if (userId != null) {
            this.deleteIdentityLink(userId, null, identityLinkType);
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.taskIdentityLinkEntities = Context.getCommandContext().getIdentityLinkManager().findIdentityLinksByTaskId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    public Map<String, Object> getActivityInstanceVariables() {
        if (this.execution != null) {
            return this.execution.getVariables();
        }
        return Collections.EMPTY_MAP;
    }

    public void setExecutionVariables(Map<String, Object> parameters) {
        if (this.getExecution() != null) {
            this.execution.setVariables(parameters);
        }
    }

    public String toString() {
        return "Task[" + this.id + "]";
    }

    @Override
    public void setName(String taskName) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(NAME, this.name, taskName);
        this.name = taskName;
    }

    public void setNameWithoutCascade(String taskName) {
        this.name = taskName;
    }

    @Override
    public void setDescription(String description) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(DESCRIPTION, this.description, description);
        this.description = description;
    }

    public void setDescriptionWithoutCascade(String description) {
        this.description = description;
    }

    @Override
    public void setAssignee(String assignee) {
        this.ensureTaskActive();
        this.registerCommandContextCloseListener();
        if (assignee == null && this.assignee == null) {
            return;
        }
        this.propertyChanged(ASSIGNEE, this.assignee, assignee);
        this.assignee = assignee;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            this.fireEvent("assignment");
        }
    }

    public void setAssigneeWithoutCascade(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public void setOwner(String owner) {
        this.ensureTaskActive();
        this.registerCommandContextCloseListener();
        if (owner == null && this.owner == null) {
            return;
        }
        this.propertyChanged(OWNER, this.owner, owner);
        this.owner = owner;
    }

    public void setOwnerWithoutCascade(String owner) {
        this.owner = owner;
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(DUE_DATE, this.dueDate, dueDate);
        this.dueDate = dueDate;
    }

    public void setDueDateWithoutCascade(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public void setPriority(int priority) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(PRIORITY, this.priority, priority);
        this.priority = priority;
    }

    public void setPriorityWithoutCascade(int priority) {
        this.priority = priority;
    }

    @Override
    public void setParentTaskId(String parentTaskId) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(PARENT_TASK, this.parentTaskId, parentTaskId);
        this.parentTaskId = parentTaskId;
    }

    public void setParentTaskIdWithoutCascade(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public void setTaskDefinitionKeyWithoutCascade(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public void fireEvent(String taskEventName) {
        List<TaskListener> taskEventListeners;
        TaskDefinition taskDefinition = this.getTaskDefinition();
        if (taskDefinition != null && (taskEventListeners = this.getTaskDefinition().getTaskListener(taskEventName)) != null) {
            for (TaskListener taskListener : taskEventListeners) {
                ExecutionEntity execution = this.getExecution();
                if (execution != null) {
                    this.setEventName(taskEventName);
                }
                try {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListener, this, execution));
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
                }
            }
        }
    }

    protected void propertyChanged(String propertyName, Object orgValue, Object newValue) {
        if (this.propertyChanges.containsKey(propertyName)) {
            Object oldOrgValue = this.propertyChanges.get(propertyName).getOrgValue();
            if (oldOrgValue == null && newValue == null || oldOrgValue != null && oldOrgValue.equals(newValue)) {
                this.propertyChanges.remove(propertyName);
            } else {
                this.propertyChanges.get(propertyName).setNewValue(newValue);
            }
        } else if (orgValue == null && newValue != null || orgValue != null && newValue == null || orgValue != null && !orgValue.equals(newValue)) {
            this.propertyChanges.put(propertyName, new PropertyChange(propertyName, orgValue, newValue));
        }
    }

    public void setTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
        this.taskDefinitionKey = taskDefinition.getKey();
    }

    public TaskDefinition getTaskDefinition() {
        if (this.taskDefinition == null && this.taskDefinitionKey != null) {
            ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
        }
        return this.taskDefinition;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public ExecutionEntity getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    @Override
    public void setDelegationState(DelegationState delegationState) {
        this.propertyChanged(DELEGATION, (Object)this.delegationState, (Object)delegationState);
        this.delegationState = delegationState;
    }

    public void setDelegationStateWithoutCascade(DelegationState delegationState) {
        this.delegationState = delegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public void setDelegationStateString(String delegationState) {
        if (delegationState == null) {
            this.setDelegationStateWithoutCascade(null);
        } else {
            this.setDelegationStateWithoutCascade(DelegationState.valueOf(delegationState));
        }
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleted(boolean isDeleted) {
        this.propertyChanged(DELETE, this.isDeleted, isDeleted);
        this.isDeleted = isDeleted;
    }

    @Override
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public Map<String, VariableInstanceEntity> getVariableInstances() {
        this.variableStore.ensureVariableInstancesInitialized();
        return this.variableStore.getVariableInstances();
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    @Override
    public void setFollowUpDate(Date followUpDate) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(FOLLOW_UP_DATE, this.followUpDate, followUpDate);
        this.followUpDate = followUpDate;
    }

    public void setFollowUpDateWithoutCascade(Date followUpDate) {
        this.followUpDate = followUpDate;
    }

    @Override
    public void onCommandContextClose(CommandContext commandContext) {
        if (commandContext.getDbSqlSession().isUpdated(this)) {
            commandContext.getHistoricTaskInstanceManager().updateHistoricTaskInstance(this);
        }
    }

    protected void registerCommandContextCloseListener() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.registerCommandContextCloseListener(this);
        }
    }

    public Map<String, PropertyChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void createHistoricTaskDetails(String operation) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            ArrayList<PropertyChange> values = new ArrayList<PropertyChange>(this.propertyChanges.values());
            commandContext.getOperationLogManager().logTaskOperations(operation, this, values);
        }
        this.propertyChanges.clear();
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }
}

