/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessDefinitionManager
extends AbstractManager {
    public ProcessDefinitionEntity findLatestProcessDefinitionByKey(String processDefinitionKey) {
        return (ProcessDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestProcessDefinitionByKey", processDefinitionKey);
    }

    public void deleteProcessDefinitionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteProcessDefinitionsByDeploymentId", deploymentId);
    }

    public ProcessDefinitionEntity findLatestProcessDefinitionById(String processDefinitionId) {
        return (ProcessDefinitionEntity)this.getDbSqlSession().selectOne("selectProcessDefinitionById", processDefinitionId);
    }

    public List<ProcessDefinition> findProcessDefinitionsByQueryCriteria(ProcessDefinitionQueryImpl processDefinitionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectProcessDefinitionsByQueryCriteria", processDefinitionQuery, page);
    }

    public long findProcessDefinitionCountByQueryCriteria(ProcessDefinitionQueryImpl processDefinitionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessDefinitionCountByQueryCriteria", processDefinitionQuery);
    }

    public ProcessDefinitionEntity findProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("processDefinitionKey", processDefinitionKey);
        return (ProcessDefinitionEntity)this.getDbSqlSession().selectOne("selectProcessDefinitionByDeploymentAndKey", parameters);
    }

    public ProcessDefinition findProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionQueryImpl processDefinitionQuery = new ProcessDefinitionQueryImpl().processDefinitionKey(processDefinitionKey).processDefinitionVersion(processDefinitionVersion);
        List<ProcessDefinition> results = this.findProcessDefinitionsByQueryCriteria(processDefinitionQuery, null);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new ProcessEngineException("There are " + results.size() + " process definitions with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'.");
        }
        return null;
    }

    public List<ProcessDefinition> findProcessDefinitionsStartableByUser(String user) {
        return new ProcessDefinitionQueryImpl().startableByUser(user).list();
    }

    public List<User> findProcessDefinitionPotentialStarterUsers() {
        return null;
    }

    public List<Group> findProcessDefinitionPotentialStarterGroups() {
        return null;
    }

    public void updateProcessDefinitionSuspensionStateById(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateProcessDefinitionSuspensionStateByParameters", parameters);
    }

    public void updateProcessDefinitionSuspensionStateByKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateProcessDefinitionSuspensionStateByParameters", parameters);
    }
}

