/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.jobexecutor.ExclusiveJobAddedNotification;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.jobexecutor.MessageAddedNotification;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;

public class JobManager
extends AbstractManager {
    public void send(MessageEntity message) {
        message.insert();
        this.hintJobExecutor(message);
    }

    public void schedule(TimerEntity timer) {
        Date duedate = timer.getDuedate();
        if (duedate == null) {
            throw new ProcessEngineException("duedate is null");
        }
        timer.insert();
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        int waitTimeInMillis = jobExecutor.getWaitTimeInMillis();
        if (duedate.getTime() < ClockUtil.getCurrentTime().getTime() + (long)waitTimeInMillis) {
            this.hintJobExecutor(timer);
        }
    }

    protected void hintJobExecutor(JobEntity job) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        TransactionListener transactionListener = null;
        if (!job.isSuspended() && job.isExclusive() && jobExecutorContext != null && jobExecutorContext.isExecutingExclusiveJob()) {
            Date currentTime = ClockUtil.getCurrentTime();
            job.setLockExpirationTime(new Date(currentTime.getTime() + (long)jobExecutor.getLockTimeInMillis()));
            job.setLockOwner(jobExecutor.getLockOwner());
            transactionListener = new ExclusiveJobAddedNotification(job.getId());
        } else {
            transactionListener = new MessageAddedNotification(jobExecutor);
        }
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    public void cancelTimers(ExecutionEntity execution) {
        List<TimerEntity> timers = Context.getCommandContext().getJobManager().findTimersByExecutionId(execution.getId());
        for (TimerEntity timer : timers) {
            timer.delete();
        }
    }

    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getDbSqlSession().selectOne("selectJob", jobId);
    }

    public List<JobEntity> findNextJobsToExecute(Page page) {
        Set<String> registeredDeployments;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date now = ClockUtil.getCurrentTime();
        params.put("now", now);
        params.put("deploymentAware", Context.getProcessEngineConfiguration().isJobExecutorDeploymentAware());
        if (Context.getProcessEngineConfiguration().isJobExecutorDeploymentAware() && !(registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments()).isEmpty()) {
            params.put("deploymentIds", registeredDeployments);
        }
        return this.getDbSqlSession().selectList("selectNextJobsToExecute", params, page);
    }

    public List<Job> findJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectJobsByExecutionId", executionId);
    }

    public List<JobEntity> findExclusiveJobsToExecute(String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", processInstanceId);
        params.put("now", ClockUtil.getCurrentTime());
        return this.getDbSqlSession().selectList("selectExclusiveJobsToExecute", params);
    }

    public List<TimerEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbSqlSession().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    public List<TimerEntity> findTimersByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    public List<Job> findJobsByConfiguration(String jobHandlerType, String jobHandlerConfiguration) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handlerType", jobHandlerType);
        params.put("handlerConfiguration", jobHandlerConfiguration);
        return this.getDbSqlSession().selectList("selectJobsByConfiguration", params);
    }

    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    public void updateJobSuspensionStateById(String jobId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobId", jobId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateJobSuspensionStateByJobDefinitionId(String jobDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateJobSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateJobSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put("handlerType", "timer-start-event");
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateJobSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put("handlerType", "timer-start-event");
        this.getDbSqlSession().update("updateJobSuspensionStateByParameters", parameters);
    }

    public void updateFailedJobRetriesByJobDefinitionId(String jobDefinitionId, int retries) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("retries", retries);
        this.getDbSqlSession().update("updateFailedJobRetriesByParameters", parameters);
    }
}

