/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.engine;

import java.util.Map;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormFieldValidationConstraint;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.form.engine.FormEngine;
import org.camunda.bpm.engine.impl.form.engine.FormPropertyAdapter;
import org.camunda.bpm.engine.impl.form.engine.HtmlDocumentBuilder;
import org.camunda.bpm.engine.impl.form.engine.HtmlElementWriter;
import org.camunda.bpm.engine.impl.form.type.EnumFormType;

public class HtmlFormEngine
implements FormEngine {
    @Override
    public String getName() {
        return "html";
    }

    @Override
    public Object renderStartForm(StartFormData startForm) {
        return this.renderFormData(startForm);
    }

    @Override
    public Object renderTaskForm(TaskFormData taskForm) {
        return this.renderFormData(taskForm);
    }

    protected String renderFormData(FormData formData) {
        if (formData == null || (formData.getFormFields() == null || formData.getFormFields().isEmpty()) && (formData.getFormProperties() == null || formData.getFormProperties().isEmpty())) {
            return null;
        }
        HtmlDocumentBuilder documentBuilder = new HtmlDocumentBuilder(new HtmlElementWriter("form").attribute("class", "form-horizontal"));
        for (FormField formField : formData.getFormFields()) {
            this.renderFormField(formField, documentBuilder);
        }
        for (FormProperty formProperty : formData.getFormProperties()) {
            this.renderFormField(new FormPropertyAdapter(formProperty), documentBuilder);
        }
        documentBuilder.endElement();
        return documentBuilder.getHtmlString();
    }

    protected void renderFormField(FormField formField, HtmlDocumentBuilder documentBuilder) {
        documentBuilder.startElement(new HtmlElementWriter("div").attribute("class", "control-group"));
        documentBuilder.startElement(new HtmlElementWriter("label").attribute("class", "control-label").textContent(formField.getLabel())).endElement();
        documentBuilder.startElement(new HtmlElementWriter("div").attribute("class", "controls"));
        if ("enum".equals(formField.getTypeName())) {
            this.renderSelectBox(formField, documentBuilder);
        } else {
            this.renderInputField(formField, documentBuilder);
        }
        documentBuilder.endElement();
        documentBuilder.endElement();
    }

    protected void renderInputField(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter inputField = new HtmlElementWriter("input", true);
        this.addCommonFormFieldAttributes(formField, inputField);
        Object defaultValue = formField.getDefaultValue();
        if (defaultValue != null) {
            inputField.attribute("value", defaultValue.toString());
        }
        documentBuilder.startElement(inputField).endElement();
    }

    protected void renderSelectBox(FormField formField, HtmlDocumentBuilder documentBuilder) {
        HtmlElementWriter selectBox = new HtmlElementWriter("select", false);
        this.addCommonFormFieldAttributes(formField, selectBox);
        selectBox.attribute("type", "string");
        documentBuilder.startElement(selectBox);
        this.renderSelectOptions(formField, documentBuilder);
        documentBuilder.endElement();
    }

    protected void renderSelectOptions(FormField formField, HtmlDocumentBuilder documentBuilder) {
        EnumFormType enumFormType = (EnumFormType)formField.getType();
        Map<String, String> values = enumFormType.getValues();
        for (Map.Entry<String, String> value : values.entrySet()) {
            HtmlElementWriter option = new HtmlElementWriter("option", false).attribute("value", value.getKey()).textContent(value.getValue());
            Object defaultValue = formField.getDefaultValue();
            if (defaultValue != null && defaultValue.equals(value.getKey())) {
                option.attribute("selected", null);
            }
            documentBuilder.startElement(option).endElement();
        }
    }

    protected void addCommonFormFieldAttributes(FormField formField, HtmlElementWriter formControl) {
        formControl.attribute("form-field", null).attribute("type", formField.getTypeName()).attribute("name", formField.getId());
        for (FormFieldValidationConstraint constraint : formField.getValidationConstraints()) {
            formControl.attribute(constraint.getName(), (String)constraint.getConfiguration());
        }
    }
}

