/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;

public class SimpleVariableStore
implements CoreVariableStore {
    protected Map<String, SimpleVariableInstance> variables = new HashMap<String, SimpleVariableInstance>();

    @Override
    public Collection<CoreVariableInstance> getVariableInstancesValues() {
        return this.variables.values();
    }

    @Override
    public CoreVariableInstance getVariableInstance(String variableName) {
        return this.variables.get(variableName);
    }

    @Override
    public Set<String> getVariableNames() {
        return this.variables.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    @Override
    public boolean containsVariableInstance(String variableName) {
        return this.variables.containsKey(variableName);
    }

    @Override
    public CoreVariableInstance removeVariableInstance(String variableName, CoreVariableScope sourceActivityExecution) {
        return this.variables.remove(variableName);
    }

    @Override
    public void setVariableInstanceValue(CoreVariableInstance variableInstance, Object value, CoreVariableScope sourceActivityExecution) {
        ((SimpleVariableInstance)variableInstance).value = value;
    }

    @Override
    public CoreVariableInstance createVariableInstance(String variableName, Object value, CoreVariableScope sourceActivityExecution) {
        SimpleVariableInstance variableInstance = new SimpleVariableInstance(variableName, value);
        this.variables.put(variableName, variableInstance);
        return variableInstance;
    }

    @Override
    public void clearForNewValue(CoreVariableInstance variableInstance, Object newValue) {
        ((SimpleVariableInstance)variableInstance).value = null;
    }

    public static class SimpleVariableInstance
    implements CoreVariableInstance {
        protected String name;
        protected Object value;

        public SimpleVariableInstance(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isAbleToStore(Object value) {
            return true;
        }
    }
}

