/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.javax.el.ELContext;

public abstract class CoreVariableScope
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected ELContext cachedElContext;

    protected abstract CoreVariableStore getVariableStore();

    public abstract CoreVariableScope getParentVariableScope();

    @Override
    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        CoreVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Object getVariable(String variableName) {
        CoreVariableInstance variableInstance = this.getVariableStore().getVariableInstance(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        CoreVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariable(variableName);
        }
        return null;
    }

    @Override
    public Object getVariableLocal(String variableName) {
        CoreVariableInstance variableInstance = this.getVariableStore().getVariableInstance(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        return null;
    }

    @Override
    public boolean hasVariables() {
        if (!this.getVariableStore().isEmpty()) {
            return true;
        }
        CoreVariableScope parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariables();
    }

    @Override
    public boolean hasVariablesLocal() {
        return !this.getVariableStore().isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        CoreVariableScope parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariable(variableName);
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        return this.getVariableStore().containsVariableInstance(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        CoreVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        return this.getVariableStore().getVariableNames();
    }

    protected void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void removeVariables() {
        HashSet<String> variableNames = new HashSet<String>(this.getVariableStore().getVariableNames());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, this.getSourceActivityVariableScope());
    }

    protected void setVariable(String variableName, Object value, CoreVariableScope sourceActivityExecution) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocal(variableName, value, sourceActivityExecution);
            return;
        }
        CoreVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.setVariable(variableName, value);
            } else {
                parentVariableScope.setVariable(variableName, value, sourceActivityExecution);
            }
            return;
        }
        this.createVariableLocal(variableName, value, sourceActivityExecution);
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
        this.setVariableLocal(variableName, value, this.getSourceActivityVariableScope());
    }

    protected void setVariableLocal(String variableName, Object value, CoreVariableScope sourceActivityExecution) {
        CoreVariableInstance variableInstance = this.getVariableStore().getVariableInstance(variableName);
        if (variableInstance != null && !variableInstance.isAbleToStore(value)) {
            this.getVariableStore().clearForNewValue(variableInstance, value);
        }
        if (variableInstance == null) {
            this.createVariableLocal(variableName, value, sourceActivityExecution);
        } else {
            this.updateVariableInstance(variableInstance, value, sourceActivityExecution);
        }
    }

    protected void createVariableLocal(String variableName, Object value) {
        this.createVariableLocal(variableName, value, this.getSourceActivityVariableScope());
    }

    protected void createVariableLocal(String variableName, Object value, CoreVariableScope sourceActivityExecution) {
        if (this.getVariableStore().containsVariableInstance(variableName)) {
            throw new ProcessEngineException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.createVariableInstance(variableName, value, sourceActivityExecution);
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityVariableScope());
    }

    protected void removeVariable(String variableName, CoreVariableScope sourceActivityExecution) {
        if (this.getVariableStore().containsVariableInstance(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        CoreVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityVariableScope());
    }

    protected CoreVariableScope getSourceActivityVariableScope() {
        return this;
    }

    protected void removeVariableLocal(String variableName, CoreVariableScope sourceActivityExecution) {
        this.getVariableStore().removeVariableInstance(variableName, sourceActivityExecution);
    }

    protected void updateVariableInstance(CoreVariableInstance variableInstance, Object value, CoreVariableScope sourceActivityExecution) {
        this.getVariableStore().setVariableInstanceValue(variableInstance, value, sourceActivityExecution);
    }

    protected CoreVariableInstance createVariableInstance(String variableName, Object value, CoreVariableScope sourceActivityExecution) {
        return this.getVariableStore().createVariableInstance(variableName, value, sourceActivityExecution);
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }
}

