/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.operation;

import java.util.List;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.model.CoreActivity;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.PvmException;

public abstract class AbstractEventAtomicOperation<T extends CoreExecution>
implements CoreAtomicOperation<T> {
    @Override
    public boolean isAsync(T execution) {
        return false;
    }

    @Override
    public void execute(T instance) {
        CoreActivity scope = this.getScope(instance);
        List<DelegateListener<? extends BaseDelegateExecution>> listeners = scope.getListeners(this.getEventName());
        int listenerIndex = ((CoreExecution)instance).getListenerIndex();
        if (listenerIndex == 0) {
            instance = this.eventNotificationsStarted(instance);
        }
        if (!this.isSkipNotifyListeners(instance)) {
            if (listeners.size() > listenerIndex) {
                ((CoreExecution)instance).setEventName(this.getEventName());
                ((CoreExecution)instance).setEventSource(scope);
                DelegateListener<? extends BaseDelegateExecution> listener = listeners.get(listenerIndex);
                try {
                    ((CoreExecution)instance).invokeListener(listener);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
                }
                ((CoreExecution)instance).setListenerIndex(listenerIndex + 1);
                ((CoreExecution)instance).performOperationSync(this);
            } else {
                ((CoreExecution)instance).setListenerIndex(0);
                ((CoreExecution)instance).setEventName(null);
                ((CoreExecution)instance).setEventSource(null);
                this.eventNotificationsCompleted(instance);
            }
        } else {
            this.eventNotificationsCompleted(instance);
        }
    }

    protected boolean isSkipNotifyListeners(T instance) {
        return false;
    }

    protected T eventNotificationsStarted(T instance) {
        return instance;
    }

    protected abstract CoreActivity getScope(T var1);

    protected abstract String getEventName();

    protected abstract void eventNotificationsCompleted(T var1);
}

