/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.connect.Connector;
import org.camunda.bpm.connect.ConnectorRequest;
import org.camunda.bpm.connect.interceptor.RequestInterceptor;
import org.camunda.bpm.engine.ProcessEngineException;

public class Connectors {
    protected Map<String, Class<? extends Connector<?>>> registeredConnectors = new HashMap();
    protected List<RequestInterceptor> globalRequestInterceptors = new ArrayList<RequestInterceptor>();

    public void addConnector(String id, Class<? extends Connector<?>> connector) {
        this.registeredConnectors.put(id, connector);
    }

    public Class<? extends Connector<?>> getConnector(String id) {
        return this.registeredConnectors.get(id);
    }

    public <T extends Connector<ConnectorRequest<?>>> T crateConnectorInstance(String id) {
        Class<Connector<?>> connector = this.getConnector(id);
        if (connector == null) {
            throw new ProcessEngineException("Cannot create instance of connector with id '" + id + "' : no such connector registered.");
        }
        try {
            Connector<?> connectorInstance = connector.newInstance();
            connectorInstance.getRequestInterceptors().addAll(this.globalRequestInterceptors);
            return (T)connectorInstance;
        }
        catch (InstantiationException e) {
            throw new ProcessEngineException("Cound not create instance of connector '" + id + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("Cound not create instance of connector '" + id + "': " + e.getMessage(), e);
        }
    }
}

