/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.operation;

import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.PvmException;

public class AtomicOperationActivityExecute
implements CmmnAtomicOperation {
    private static Logger log = Logger.getLogger(AtomicOperationActivityExecute.class.getName());

    @Override
    public boolean isAsync(CmmnExecution execution) {
        return false;
    }

    @Override
    public void execute(CmmnExecution execution) {
        CmmnActivity activity = execution.getActivity();
        CmmnActivityBehavior activityBehavior = activity.getActivityBehavior();
        if (activityBehavior == null) {
            throw new PvmException("no behavior specified in " + activity);
        }
        log.fine(execution + " executes " + activity + ": " + activityBehavior.getClass().getName());
        try {
            activityBehavior.execute(execution);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't execute activity <" + activity.getProperty("type") + " id=\"" + activity.getId() + "\" ...>: " + e.getMessage(), e);
        }
    }

    @Override
    public String getCanonicalName() {
        return "activity-execute";
    }
}

