/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.CmmnModelExecutionContext;
import org.camunda.bpm.engine.delegate.ProcessEngineServicesAware;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.core.variable.SimpleVariableStore;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;

public class CaseExecutionImpl
extends CmmnExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CaseExecutionImpl.class.getName());
    private static AtomicInteger idGenerator = new AtomicInteger();
    protected List<CaseExecutionImpl> caseExecutions;
    protected CaseExecutionImpl caseInstance;
    protected CaseExecutionImpl parent;
    protected SimpleVariableStore variableStore = new SimpleVariableStore();

    @Override
    public String getCaseDefinitionId() {
        return this.getCaseDefinition().getId();
    }

    @Override
    public CaseExecutionImpl getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionImpl)parent;
    }

    @Override
    public String getParentId() {
        return this.getParent().getId();
    }

    @Override
    public String getActivityId() {
        return this.getActivity().getId();
    }

    @Override
    public String getActivityName() {
        return this.getActivity().getName();
    }

    public List<CaseExecutionImpl> getCaseExecutions() {
        if (this.caseExecutions == null) {
            this.caseExecutions = new ArrayList<CaseExecutionImpl>();
        }
        return this.caseExecutions;
    }

    @Override
    public CaseExecutionImpl getCaseInstance() {
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionImpl)caseInstance;
    }

    @Override
    protected CaseExecutionImpl createCaseExecution(CmmnActivity activity) {
        CaseExecutionImpl child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutions().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        child.setCurrentState(CaseExecutionState.AVAILABLE);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Child caseExecution " + child + " created with parent " + this);
        }
        return child;
    }

    @Override
    protected CaseExecutionImpl newCaseExecution() {
        return new CaseExecutionImpl();
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStore;
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        throw new UnsupportedOperationException(ProcessEngineServicesAware.class.getName() + " is unsupported in transient CaseExecutionImpl");
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        throw new UnsupportedOperationException(CmmnModelExecutionContext.class.getName() + " is unsupported in transient CaseExecutionImpl");
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        throw new UnsupportedOperationException(CmmnModelExecutionContext.class.getName() + " is unsupported in transient CaseExecutionImpl");
    }
}

