/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntityVariableStore;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class CaseExecutionEntity
extends CmmnExecution
implements CaseExecution,
CaseInstance,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CmmnExecution.class.getName());
    protected transient CaseExecutionEntity caseInstance;
    protected transient CaseExecutionEntity parent;
    protected List<CaseExecutionEntity> caseExecutions;
    protected CaseExecutionEntityVariableStore variableStore = new CaseExecutionEntityVariableStore(this);
    protected int revision = 1;
    protected String caseDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String caseInstanceId;
    protected String parentId;

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Override
    public CmmnCaseDefinition getCaseDefinition() {
        this.ensureCaseDefinitionInitialized();
        return this.caseDefinition;
    }

    @Override
    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        super.setCaseDefinition(caseDefinition);
        this.caseDefinitionId = null;
        if (caseDefinition != null) {
            this.caseDefinitionId = caseDefinition.getId();
        }
    }

    protected void ensureCaseDefinitionInitialized() {
        if (this.caseDefinition == null && this.caseDefinitionId != null) {
            CaseDefinitionEntity deployedCaseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
            this.setCaseDefinition(deployedCaseDefinition);
        }
    }

    @Override
    public CaseExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.parentId);
        }
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public CmmnActivity getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public void setActivity(CmmnActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = (String)activity.getProperty("name");
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getCaseDefinition().findActivity(this.activityId));
        }
    }

    public List<CaseExecutionEntity> getCaseExecutions() {
        this.ensureCaseExecutionsInitialized();
        return this.caseExecutions;
    }

    protected void ensureCaseExecutionsInitialized() {
        if (this.caseExecutions == null) {
            this.caseExecutions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByParentCaseExecutionId(this.id);
        }
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public CaseExecutionEntity getCaseInstance() {
        this.ensureCaseInstanceInitialized();
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionEntity)caseInstance;
        if (caseInstance != null) {
            this.caseInstanceId = this.caseInstance.getId();
        }
    }

    protected void ensureCaseInstanceInitialized() {
        if (this.caseInstance == null && this.caseInstanceId != null) {
            this.caseInstance = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseInstanceId);
        }
    }

    @Override
    public boolean isCaseInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    protected CaseExecutionEntity createCaseExecution(CmmnActivity activity) {
        CaseExecutionEntity child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutions().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        child.setCurrentState(CaseExecutionState.AVAILABLE);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Child caseExecution " + child + " created with parent " + this);
        }
        return child;
    }

    @Override
    protected CaseExecutionEntity newCaseExecution() {
        CaseExecutionEntity newCaseExecution = new CaseExecutionEntity();
        Context.getCommandContext().getCaseExecutionManager().insertCaseExecution(newCaseExecution);
        return newCaseExecution;
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStore;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setCaseInstanceId(this.caseInstanceId);
        variableInstance.setCaseExecutionId(this.id);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByCaseExecutionId(this.id);
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CaseExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public void remove() {
        super.remove();
        this.variableStore.removeVariablesWithoutFiringEvents();
        Context.getCommandContext().getCaseExecutionManager().deleteCaseExecution(this);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("parentId", this.parentId);
        persistentState.put("currentState", this.currentState);
        persistentState.put("previousState", this.previousState);
        return persistentState;
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        if (this.caseDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        }
        return null;
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        CmmnModelInstance cmmnModelInstance = this.getCmmnModelInstance();
        if (cmmnModelInstance != null) {
            ModelElementInstance modelElementInstance = cmmnModelInstance.getModelElementById(this.activityId);
            return (CmmnElement)modelElementInstance;
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }
}

