/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.repository;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryProperty;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;

public class CaseDefinitionQueryImpl
extends AbstractQuery<CaseDefinitionQuery, CaseDefinition>
implements CaseDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;

    public CaseDefinitionQueryImpl() {
    }

    public CaseDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public CaseDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CaseDefinitionQuery caseDefinitionId(String caseDefinitionId) {
        this.assertParamNotNull("caseDefinitionId", caseDefinitionId);
        this.id = caseDefinitionId;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionCategory(String caseDefinitionCategory) {
        this.assertParamNotNull("category", caseDefinitionCategory);
        this.category = caseDefinitionCategory;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionCategoryLike(String caseDefinitionCategoryLike) {
        this.assertParamNotNull("categoryLike", caseDefinitionCategoryLike);
        this.categoryLike = caseDefinitionCategoryLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionName(String caseDefinitionName) {
        this.assertParamNotNull("name", caseDefinitionName);
        this.name = caseDefinitionName;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionNameLike(String caseDefinitionNameLike) {
        this.assertParamNotNull("nameLike", caseDefinitionNameLike);
        this.nameLike = caseDefinitionNameLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionKey(String caseDefinitionKey) {
        this.assertParamNotNull("key", caseDefinitionKey);
        this.key = caseDefinitionKey;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionKeyLike(String caseDefinitionKeyLike) {
        this.assertParamNotNull("keyLike", caseDefinitionKeyLike);
        this.keyLike = caseDefinitionKeyLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery deploymentId(String deploymentId) {
        this.assertParamNotNull("deploymentId", deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionVersion(Integer caseDefinitionVersion) {
        this.assertParamNotNull("version", caseDefinitionVersion);
        if (caseDefinitionVersion <= 0) {
            throw new ProcessEngineException("version must be positive");
        }
        this.version = caseDefinitionVersion;
        return this;
    }

    @Override
    public CaseDefinitionQuery latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionResourceName(String resourceName) {
        this.assertParamNotNull("resourceName", resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionResourceNameLike(String resourceNameLike) {
        this.assertParamNotNull("resourceNameLike", resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionCategory() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_CATEGORY);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionKey() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_KEY);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionId() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionVersion() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_VERSION);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionName() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_NAME);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByDeploymentId() {
        this.orderBy(CaseDefinitionQueryProperty.DEPLOYMENT_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getCaseDefinitionManager().findCaseDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<CaseDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getCaseDefinitionManager().findCaseDefinitionsByQueryCriteria(this, page);
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.name != null || this.nameLike != null || this.version != null || this.deploymentId != null)) {
            throw new ProcessEngineException("Calling latest() can only be used in combination with key(String) and keyLike(String)");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }
}

