/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.cmd.CreateCaseInstanceCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceBuilder;

public class CaseInstanceBuilderImpl
implements CaseInstanceBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String businessKey;
    protected Map<String, Object> variables;

    public CaseInstanceBuilderImpl(CommandExecutor commandExecutor, String caseDefinitionKey, String caseDefinitionId) {
        this(caseDefinitionKey, caseDefinitionId);
        if (commandExecutor == null) {
            throw new ProcessEngineException("commandExecutor cannot be null");
        }
        this.commandExecutor = commandExecutor;
    }

    public CaseInstanceBuilderImpl(CommandContext commandContext, String caseDefinitionKey, String caseDefinitionId) {
        this(caseDefinitionKey, caseDefinitionId);
        if (commandContext == null) {
            throw new ProcessEngineException("commandContext cannot be null");
        }
        this.commandContext = commandContext;
    }

    private CaseInstanceBuilderImpl(String caseDefinitionKey, String caseDefinitionId) {
        this.caseDefinitionKey = caseDefinitionKey;
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public CaseInstanceBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public CaseInstanceBuilder setVariable(String variableName, Object variableValue) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, variableValue);
        return this;
    }

    @Override
    public CaseInstanceBuilder setVariables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.putAll(variables);
        return this;
    }

    @Override
    public CaseInstance create() {
        CreateCaseInstanceCmd command = new CreateCaseInstanceCmd(this);
        if (this.commandExecutor != null) {
            return this.commandExecutor.execute(command);
        }
        return command.execute(this.commandContext);
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

