/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.DelegationState;

public class SubmitTaskFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, Object> properties;

    public SubmitTaskFormCmd(String taskId, Map<String, Object> properties) {
        this.taskId = taskId;
        this.properties = properties;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int historyLevel = processEngineConfiguration.getHistoryLevel();
        ExecutionEntity execution = task.getExecution();
        if (historyLevel >= 2 && execution != null) {
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            for (String propertyId : this.properties.keySet()) {
                Object propertyValue = this.properties.get(propertyId);
                HistoryEvent evt = eventProducer.createFormPropertyUpdateEvt(execution, propertyId, propertyValue, this.taskId);
                eventHandler.handleEvent(evt);
            }
        }
        TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
        taskFormHandler.submitFormProperties(this.properties, task.getExecution());
        if (DelegationState.PENDING.equals((Object)task.getDelegationState())) {
            task.resolve();
            task.createHistoricTaskDetails("Resolve");
        } else {
            task.complete();
            task.createHistoricTaskDetails("Complete");
        }
        return null;
    }
}

