/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class SubmitStartFormCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String processDefinitionId;
    protected final String businessKey;
    protected Map<String, Object> properties;

    public SubmitStartFormCmd(String processDefinitionId, String businessKey, Map<String, Object> properties) {
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.properties = properties;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessDefinitionEntity processDefinition = processEngineConfiguration.getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ProcessEngineException("No process definition found for id = '" + this.processDefinitionId + "'");
        }
        ExecutionEntity processInstance = null;
        processInstance = this.businessKey != null ? processDefinition.createProcessInstance(this.businessKey) : processDefinition.createProcessInstance();
        processInstance.startWithFormProperties(this.properties);
        return processInstance;
    }
}

