/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class GetStartFormCmd
implements Command<StartFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetStartFormCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public StartFormData execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ProcessEngineException("No process definition found for id '" + this.processDefinitionId + "'");
        }
        StartFormHandler startFormHandler = processDefinition.getStartFormHandler();
        if (startFormHandler == null) {
            throw new ProcessEngineException("No startFormHandler defined in process '" + this.processDefinitionId + "'");
        }
        return startFormHandler.createStartFormData(processDefinition);
    }
}

