/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class GetExecutionVariableCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;

    public GetExecutionVariableCmd(String executionId, String variableName, boolean isLocal) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ProcessEngineException("executionId is null");
        }
        if (this.variableName == null) {
            throw new ProcessEngineException("variableName is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ProcessEngineException("execution " + this.executionId + " doesn't exist");
        }
        Object value = this.isLocal ? execution.getVariableLocal(this.variableName) : execution.getVariable(this.variableName);
        return value;
    }
}

