/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

public class DeleteHistoricProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public DeleteHistoricProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new ProcessEngineException("processInstanceId is null");
        }
        HistoricProcessInstanceEntity instance = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(this.processInstanceId);
        if (instance == null) {
            throw new ProcessEngineException("No historic process instance found with id: " + this.processInstanceId);
        }
        if (instance.getEndTime() == null) {
            throw new ProcessEngineException("Process instance is still running, cannot delete historic process instance: " + this.processInstanceId);
        }
        commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(this.processInstanceId);
        return null;
    }
}

