/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.task.TaskDefinition;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    protected TaskDefinition taskDefinition;
    protected ExpressionManager expressionManager;

    public UserTaskActivityBehavior(ExpressionManager expressionManager, TaskDefinition taskDefinition) {
        this.expressionManager = expressionManager;
        this.taskDefinition = taskDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert(execution);
        task.setExecution(execution);
        task.setTaskDefinition(this.taskDefinition);
        if (this.taskDefinition.getNameExpression() != null) {
            String name = (String)this.taskDefinition.getNameExpression().getValue(execution);
            task.setName(name);
        }
        if (this.taskDefinition.getDescriptionExpression() != null) {
            String description = (String)this.taskDefinition.getDescriptionExpression().getValue(execution);
            task.setDescription(description);
        }
        if (this.taskDefinition.getDueDateExpression() != null && (dueDate = this.taskDefinition.getDueDateExpression().getValue(execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar("dueDate");
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ProcessEngineException("Due date expression does not resolve to a Date or Date string: " + this.taskDefinition.getDueDateExpression().getExpressionText());
            }
        }
        if (this.taskDefinition.getPriorityExpression() != null && (priority = this.taskDefinition.getPriorityExpression().getValue(execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ProcessEngineException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ProcessEngineException("Priority expression does not resolve to a number: " + this.taskDefinition.getPriorityExpression().getExpressionText());
            }
        }
        this.handleAssignments(task, execution);
        Context.getCommandContext().getHistoricTaskInstanceManager().createHistoricTask(task);
        task.fireEvent("create");
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        this.leave(execution);
    }

    protected void handleAssignments(TaskEntity task, ActivityExecution execution) {
        List<String> candiates;
        Object value;
        if (this.taskDefinition.getAssigneeExpression() != null) {
            task.setAssignee((String)this.taskDefinition.getAssigneeExpression().getValue(execution));
        }
        if (!this.taskDefinition.getCandidateGroupIdExpressions().isEmpty()) {
            for (Expression groupIdExpr : this.taskDefinition.getCandidateGroupIdExpressions()) {
                value = groupIdExpr.getValue(execution);
                if (value instanceof String) {
                    candiates = this.extractCandidates((String)value);
                    task.addCandidateGroups(candiates);
                    continue;
                }
                if (value instanceof Collection) {
                    task.addCandidateGroups((Collection)value);
                    continue;
                }
                throw new ProcessEngineException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCandidateUserIdExpressions().isEmpty()) {
            for (Expression userIdExpr : this.taskDefinition.getCandidateUserIdExpressions()) {
                value = userIdExpr.getValue(execution);
                if (value instanceof String) {
                    candiates = this.extractCandidates((String)value);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value instanceof Collection) {
                    task.addCandidateUsers((Collection)value);
                    continue;
                }
                throw new ProcessEngineException("Expression did not resolve to a string or collection of strings");
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }
}

