/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.ProcessApplicationScanningUtil;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.spi.ProcessApplicationScanner;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.IoUtil;

public class ClassPathProcessApplicationScanner
implements ProcessApplicationScanner {
    private static Logger log = Logger.getLogger(ClassPathProcessApplicationScanner.class.getName());

    @Override
    public Map<String, byte[]> findResources(ClassLoader classLoader, String paResourceRootPath, URL metaFileUrl) {
        HashMap<String, byte[]> resourceMap = new HashMap<String, byte[]>();
        this.scanPaResourceRootPath(classLoader, metaFileUrl, paResourceRootPath, resourceMap);
        return resourceMap;
    }

    public void scanPaResourceRootPath(ClassLoader classLoader, URL metaFileUrl, String paResourceRootPath, Map<String, byte[]> resourceMap) {
        if (paResourceRootPath != null && !paResourceRootPath.startsWith("pa:")) {
            String strippedPath = paResourceRootPath.replace("classpath:", "");
            Enumeration<URL> resourceRoots = this.loadClasspathResourceRoots(classLoader, strippedPath);
            while (resourceRoots.hasMoreElements()) {
                URL resourceRoot = resourceRoots.nextElement();
                this.scanUrl(resourceRoot, strippedPath, false, resourceMap);
            }
        } else {
            String strippedPaResourceRootPath = null;
            if (paResourceRootPath != null) {
                strippedPaResourceRootPath = paResourceRootPath.replace("pa:", "");
                strippedPaResourceRootPath = strippedPaResourceRootPath.endsWith("/") ? strippedPaResourceRootPath : strippedPaResourceRootPath + "/";
            }
            this.scanUrl(metaFileUrl, strippedPaResourceRootPath, true, resourceMap);
        }
    }

    protected void scanUrl(URL url, String paResourceRootPath, boolean isPaLocal, Map<String, byte[]> resourceMap) {
        int withinArchive;
        String urlPath = url.toExternalForm();
        if (isPaLocal) {
            if (urlPath.startsWith("file:") || urlPath.startsWith("jar:") || urlPath.startsWith("wsjar:") || urlPath.startsWith("zip:")) {
                urlPath = url.getPath();
                withinArchive = urlPath.indexOf(33);
                if (withinArchive != -1) {
                    urlPath = urlPath.substring(0, withinArchive);
                } else {
                    File file = new File(urlPath);
                    urlPath = file.getParentFile().getParent();
                }
            }
        } else if ((urlPath.startsWith("file:") || urlPath.startsWith("jar:") || urlPath.startsWith("wsjar:") || urlPath.startsWith("zip:")) && (withinArchive = (urlPath = url.getPath()).indexOf(33)) != -1) {
            urlPath = urlPath.substring(0, withinArchive);
        }
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessEngineException("Could not decode pathname using utf-8 decoder.", e);
        }
        log.log(Level.FINEST, "Rootpath is {0}", urlPath);
        this.scanPath(urlPath, paResourceRootPath, isPaLocal, resourceMap);
    }

    protected void scanPath(String urlPath, String paResourceRootPath, boolean isPaLocal, Map<String, byte[]> resourceMap) {
        File file;
        if (urlPath.startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if (urlPath.indexOf(33) > 0) {
            urlPath = urlPath.substring(0, urlPath.indexOf(33));
        }
        if ((file = new File(urlPath)).isDirectory()) {
            String path = file.getPath();
            String rootPath = path.endsWith(File.separator) ? path : path + File.separator;
            this.handleDirectory(file, rootPath, paResourceRootPath, paResourceRootPath, isPaLocal, resourceMap);
        } else {
            this.handleArchive(file, paResourceRootPath, resourceMap);
        }
    }

    protected void handleArchive(File file, String paResourceRootPath, Map<String, byte[]> resourceMap) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String processFileName = zipEntry.getName();
                if (!ProcessApplicationScanningUtil.isDeployable(processFileName) || !this.isBelowPath(processFileName, paResourceRootPath)) continue;
                this.addResource(zipFile.getInputStream(zipEntry), resourceMap, file.getName() + "!", processFileName);
                Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
                while (entries2.hasMoreElements()) {
                    ZipEntry zipEntry2 = entries2.nextElement();
                    String diagramFileName = zipEntry2.getName();
                    if (!ProcessApplicationScanningUtil.isDiagramForProcess(diagramFileName, processFileName)) continue;
                    this.addResource(zipFile.getInputStream(zipEntry), resourceMap, file.getName() + "!", diagramFileName);
                }
            }
            zipFile.close();
        }
        catch (IOException e) {
            throw new ProcessEngineException("IOException while scanning archive '" + file + "'.", e);
        }
    }

    protected void handleDirectory(File directory, String rootPath, String localPath, String paResourceRootPath, boolean isPaLocal, Map<String, byte[]> resourceMap) {
        File[] paths = directory.listFiles();
        String currentPathSegment = localPath;
        if (localPath != null && localPath.length() > 0) {
            if (localPath.indexOf(47) > 0) {
                currentPathSegment = localPath.substring(0, localPath.indexOf(47));
                localPath = localPath.substring(localPath.indexOf(47) + 1, localPath.length());
            } else {
                localPath = null;
            }
        }
        for (File path : paths) {
            if (isPaLocal && currentPathSegment != null && currentPathSegment.length() > 0) {
                if (!path.isDirectory() || !path.getName().equals(currentPathSegment)) continue;
                this.handleDirectory(path, rootPath, localPath, paResourceRootPath, isPaLocal, resourceMap);
                continue;
            }
            String processFileName = path.getPath();
            if (!path.isDirectory() && ProcessApplicationScanningUtil.isDeployable(processFileName)) {
                this.addResource(path, resourceMap, paResourceRootPath, processFileName.replace(rootPath, ""));
                for (File file : paths) {
                    String diagramFileName = file.getPath();
                    if (path.isDirectory() || !ProcessApplicationScanningUtil.isDiagramForProcess(diagramFileName, processFileName)) continue;
                    this.addResource(file, resourceMap, paResourceRootPath, diagramFileName.replace(rootPath, ""));
                }
                continue;
            }
            if (!path.isDirectory()) continue;
            this.handleDirectory(path, rootPath, localPath, paResourceRootPath, isPaLocal, resourceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResource(Object source, Map<String, byte[]> resourceMap, String resourceRootPath, String resourceName) {
        String resourcePath = (resourceRootPath == null ? "" : resourceRootPath).concat(resourceName);
        log.log(Level.FINEST, "discovered process resource {0}", resourcePath);
        InputStream inputStream = null;
        try {
            if (source instanceof File) {
                try {
                    inputStream = new FileInputStream((File)source);
                }
                catch (IOException e) {
                    throw new ProcessEngineException("Could not open file for reading " + source + ". " + e.getMessage(), e);
                }
            } else {
                inputStream = (InputStream)source;
            }
            byte[] bytes = IoUtil.readInputStream(inputStream, resourcePath);
            resourceMap.put(resourcePath, bytes);
        }
        finally {
            if (inputStream != null) {
                IoUtil.closeSilently(inputStream);
            }
        }
    }

    protected Enumeration<URL> loadClasspathResourceRoots(ClassLoader classLoader, String strippedPaResourceRootPath) {
        Enumeration<URL> resourceRoots;
        try {
            resourceRoots = classLoader.getResources(strippedPaResourceRootPath);
        }
        catch (IOException e) {
            throw new ProcessEngineException("Could not load resources at '" + strippedPaResourceRootPath + "' using classloaded '" + classLoader + "'", e);
        }
        return resourceRoots;
    }

    protected boolean isBelowPath(String processFileName, String paResourceRootPath) {
        if (paResourceRootPath == null || paResourceRootPath.length() == 0) {
            return true;
        }
        return processFileName.startsWith(paResourceRootPath);
    }
}

