/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.deployment.UndeployProcessArchiveStep;
import org.camunda.bpm.container.impl.jmx.deployment.util.DeployedProcessArchive;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.engine.ProcessEngineException;

public class UndeployProcessArchivesStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        AbstractProcessApplication processApplication;
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_APPLICATION, (processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication")).getName());
        if (deployedProcessApplication == null) {
            throw new ProcessEngineException("Cannot find process application with name " + processApplication.getName() + ".");
        }
        Map<String, DeployedProcessArchive> deploymentMap = deployedProcessApplication.getProcessArchiveDeploymentMap();
        if (deploymentMap != null) {
            List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
            for (ProcessesXml processesXml : processesXmls) {
                for (ProcessArchiveXml parsedProcessArchive : processesXml.getProcessArchives()) {
                    DeployedProcessArchive deployedProcessArchive = deploymentMap.get(parsedProcessArchive.getName());
                    if (deployedProcessArchive == null) continue;
                    operationContext.addStep(new UndeployProcessArchiveStep(deployedProcessApplication, parsedProcessArchive, deployedProcessArchive.getProcessEngineName()));
                }
            }
        }
    }
}

