/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.metadata.BpmPlatformXmlParser;
import org.camunda.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;

public abstract class AbstractParseBpmPlatformXmlStep
extends MBeanDeploymentOperationStep {
    protected final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    public static final String BPM_PLATFORM_XML_FILE = "bpm-platform.xml";
    public static final String BPM_PLATFORM_XML_LOCATION = "bpm-platform-xml";
    public static final String BPM_PLATFORM_XML_ENVIRONMENT_VARIABLE = "BPM_PLATFORM_XML";
    public static final String BPM_PLATFORM_XML_SYSTEM_PROPERTY = "bpm.platform.xml";
    public static final String BPM_PLATFORM_XML_RESOURCE_LOCATION = "META-INF/bpm-platform.xml";

    @Override
    public String getName() {
        return "Parsing bpm-platform.xml file";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        URL bpmPlatformXmlSource = this.getBpmPlatformXmlStream(operationContext);
        if (bpmPlatformXmlSource == null) {
            throw new ProcessEngineException("Unable to find bpm-platform.xml. This file is necessary for deploying the camunda BPM platform");
        }
        BpmPlatformXml bpmPlatformXml = new BpmPlatformXmlParser().createParse().sourceUrl(bpmPlatformXmlSource).execute().getBpmPlatformXml();
        operationContext.addAttachment("bpmPlatformXml", bpmPlatformXml);
    }

    protected URL checkValidBpmPlatformXmlResourceLocation(String url) {
        url = this.autoCompleteUrl(url);
        URL fileLocation = null;
        try {
            fileLocation = this.checkValidUrlLocation(url);
            if (fileLocation == null) {
                fileLocation = this.checkValidFileLocation(url);
            }
        }
        catch (MalformedURLException e) {
            throw new ProcessEngineException("'" + url + "' is not a valid camunda bpm platform configuration resource location.", e);
        }
        return fileLocation;
    }

    protected String autoCompleteUrl(String url) {
        if (url != null) {
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.log(Level.FINE, "Autocompleting url : [" + url + "]");
            }
            if (!url.endsWith(BPM_PLATFORM_XML_FILE)) {
                String appender = url.contains("/") ? "/" : "\\";
                if (!url.endsWith("/") && !url.endsWith("\\\\")) {
                    url = url + appender;
                }
                url = url + BPM_PLATFORM_XML_FILE;
            }
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.log(Level.FINE, "Autocompleted url : [" + url + "]");
            }
        }
        return url;
    }

    protected URL checkValidUrlLocation(String url) throws MalformedURLException {
        if (url == null || url.isEmpty()) {
            return null;
        }
        Pattern urlPattern = Pattern.compile("^(https?://).*/bpm-platform\\.xml$", 66);
        Matcher urlMatcher = urlPattern.matcher(url);
        if (urlMatcher.matches()) {
            return new URL(url);
        }
        return null;
    }

    protected URL checkValidFileLocation(String url) throws MalformedURLException {
        File configurationLocation;
        if (url == null || url.isEmpty()) {
            return null;
        }
        Pattern filePattern = Pattern.compile("^(/|[A-z]://?|[A-z]:\\\\).*[/|\\\\]bpm-platform\\.xml$", 66);
        Matcher fileMatcher = filePattern.matcher(url);
        if (fileMatcher.matches() && (configurationLocation = new File(url)).isAbsolute() && configurationLocation.exists()) {
            return configurationLocation.toURI().toURL();
        }
        return null;
    }

    protected URL lookupBpmPlatformXmlLocationFromJndi() {
        String jndi = "java:comp/env/bpm-platform-xml";
        try {
            String bpmPlatformXmlLocation = (String)InitialContext.doLookup(jndi);
            URL fileLocation = this.checkValidBpmPlatformXmlResourceLocation(bpmPlatformXmlLocation);
            if (fileLocation != null) {
                this.LOGGER.log(Level.INFO, "Found camunda bpm platform configuration in JNDI [" + jndi + "] at " + fileLocation.toString());
            }
            return fileLocation;
        }
        catch (NamingException e) {
            this.LOGGER.log(Level.FINE, "Failed to look up camunda bpm platform configuration in JNDI [" + jndi + "].", e);
            return null;
        }
    }

    protected URL lookupBpmPlatformXmlLocationFromEnvironmentVariable() {
        URL fileLocation;
        String bpmPlatformXmlLocation = System.getenv(BPM_PLATFORM_XML_ENVIRONMENT_VARIABLE);
        String logStatement = "environment variable [BPM_PLATFORM_XML]";
        if (bpmPlatformXmlLocation == null) {
            bpmPlatformXmlLocation = System.getProperty(BPM_PLATFORM_XML_SYSTEM_PROPERTY);
            logStatement = "system property [bpm.platform.xml]";
        }
        if ((fileLocation = this.checkValidBpmPlatformXmlResourceLocation(bpmPlatformXmlLocation)) != null) {
            this.LOGGER.log(Level.INFO, "Found camunda bpm platform configuration through " + logStatement + " at " + fileLocation.toString());
        }
        return fileLocation;
    }

    protected URL lookupBpmPlatformXmlFromClassPath(String resourceLocation) {
        URL fileLocation = ClassLoaderUtil.getClassloader(this.getClass()).getResource(resourceLocation);
        if (fileLocation != null) {
            this.LOGGER.log(Level.INFO, "Found camunda bpm platform configuration in classpath [" + resourceLocation + "] at " + fileLocation.toString());
        }
        return fileLocation;
    }

    protected URL lookupBpmPlatformXmlFromClassPath() {
        return this.lookupBpmPlatformXmlFromClassPath(BPM_PLATFORM_XML_RESOURCE_LOCATION);
    }

    protected URL lookupBpmPlatformXml() {
        URL fileLocation = this.lookupBpmPlatformXmlLocationFromJndi();
        if (fileLocation == null) {
            fileLocation = this.lookupBpmPlatformXmlLocationFromEnvironmentVariable();
        }
        if (fileLocation == null) {
            fileLocation = this.lookupBpmPlatformXmlFromClassPath();
        }
        return fileLocation;
    }

    protected abstract URL getBpmPlatformXmlStream(MBeanDeploymentOperation var1);
}

