/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test;

import java.io.FileNotFoundException;
import java.util.Date;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;

public class ProcessEngineRule
extends TestWatchman {
    protected String configurationResource = "camunda.cfg.xml";
    protected String configurationResourceCompat = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;

    public ProcessEngineRule() {
    }

    public ProcessEngineRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ProcessEngineRule(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void starting(FrameworkMethod method) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        this.initializeServices();
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, method.getMethod().getDeclaringClass(), method.getName());
    }

    protected void initializeProcessEngine() {
        try {
            this.processEngine = TestHelper.getProcessEngine(this.configurationResource);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(this.configurationResourceCompat).buildProcessEngine();
            }
            throw ex;
        }
    }

    protected void initializeServices() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
    }

    public void finished(FrameworkMethod method) {
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, method.getMethod().getDeclaringClass(), method.getName());
        ClockUtil.reset();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoricDataService(HistoryService historicDataService) {
        this.historyService = historicDataService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }
}

