/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.runtime;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.Execution;

public class DefaultCorrelationHandler
implements CorrelationHandler {
    private static final Logger LOGGER = Logger.getLogger(DefaultCorrelationHandler.class.getName());

    @Override
    public MessageCorrelationResult correlateMessage(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        MessageCorrelationResult result = this.tryCorrelateMessageToExecution(commandContext, messageName, correlationSet);
        if (result == null) {
            result = this.tryCorrelateMessageToProcessDefinition(commandContext, messageName, correlationSet);
        }
        return result;
    }

    protected MessageCorrelationResult tryCorrelateMessageToExecution(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        String processInstanceId;
        String businessKey;
        ExecutionQueryImpl query = new ExecutionQueryImpl();
        Map<String, Object> correlationKeys = correlationSet.getCorrelationKeys();
        if (correlationKeys != null) {
            for (Map.Entry<String, Object> correlationKey : correlationKeys.entrySet()) {
                query.processVariableValueEquals(correlationKey.getKey(), correlationKey.getValue());
            }
        }
        if ((businessKey = correlationSet.getBusinessKey()) != null) {
            query.processInstanceBusinessKey(businessKey);
        }
        if ((processInstanceId = correlationSet.getProcessInstanceId()) != null) {
            query.processInstanceId(processInstanceId);
        }
        query.messageEventSubscriptionName(messageName);
        List<Execution> matchingExecutions = query.executeList(commandContext, null);
        if (matchingExecutions.size() > 1) {
            throw new MismatchingMessageCorrelationException(messageName, businessKey, correlationKeys, String.valueOf(matchingExecutions.size()) + " executions match the correlation keys. Should be one or zero.");
        }
        if (!matchingExecutions.isEmpty()) {
            Execution matchingExecution = matchingExecutions.get(0);
            return MessageCorrelationResult.matchedExecution((ExecutionEntity)matchingExecution);
        }
        return null;
    }

    protected MessageCorrelationResult tryCorrelateMessageToProcessDefinition(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        String processDefinitionId;
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionManager().findMessageStartEventSubscriptionByName(messageName);
        if (messageEventSubscription == null || messageEventSubscription.getConfiguration() == null) {
            return null;
        }
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId = messageEventSubscription.getConfiguration());
        if (processDefinition == null) {
            LOGGER.log(Level.FINE, "Found event subscription with {0} but process definition {1} could not be found.", new Object[]{messageEventSubscription, processDefinitionId});
            return null;
        }
        return MessageCorrelationResult.matchedProcessDefinition(processDefinition, messageEventSubscription.getActivityId());
    }
}

