/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperationActivityInstanceEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationActivityEnd
extends AtomicOperationActivityInstanceEnd {
    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return (ScopeImpl)((Object)execution.getActivity());
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        super.eventNotificationsCompleted(execution);
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ActivityImpl parentActivity = activity.getParentActivity();
        if (parentActivity != null && !parentActivity.isScope()) {
            execution.setActivity(parentActivity);
            execution.performOperation(ACTIVITY_END);
        } else if (execution.isProcessInstance()) {
            execution.performOperation(PROCESS_END);
        } else if (execution.isScope()) {
            ActivityBehavior parentActivityBehavior;
            ActivityBehavior activityBehavior = parentActivityBehavior = parentActivity != null ? parentActivity.getActivityBehavior() : null;
            if (parentActivityBehavior instanceof CompositeActivityBehavior) {
                CompositeActivityBehavior compositeActivityBehavior = (CompositeActivityBehavior)parentActivity.getActivityBehavior();
                if (activity.isScope() && activity.getOutgoingTransitions().isEmpty()) {
                    InterpretableExecution parentScopeExecution = execution.getParent();
                    execution.destroy();
                    execution.remove();
                    parentScopeExecution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(parentScopeExecution);
                } else {
                    execution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(execution);
                }
            } else {
                InterpretableExecution parentScopeExecution = execution.getParent();
                execution.destroy();
                execution.remove();
                if (activity.getParent() == activity.getProcessDefinition() && activity.getOutgoingTransitions().isEmpty()) {
                    parentScopeExecution.setActivity(activity);
                    parentScopeExecution.performOperation(AtomicOperation.PROCESS_END);
                } else {
                    parentScopeExecution.setActivity(parentActivity);
                    parentScopeExecution.performOperation(ACTIVITY_END);
                }
            }
        } else {
            execution.remove();
            InterpretableExecution concurrentRoot = execution.getParent();
            if (concurrentRoot.getExecutions().size() == 1) {
                InterpretableExecution lastConcurrent = (InterpretableExecution)concurrentRoot.getExecutions().get(0);
                if (!lastConcurrent.isScope()) {
                    concurrentRoot.setActivity((ActivityImpl)lastConcurrent.getActivity());
                    lastConcurrent.setReplacedBy(concurrentRoot);
                    if (lastConcurrent.getExecutions().size() > 0) {
                        concurrentRoot.getExecutions().clear();
                        for (ActivityExecution activityExecution : lastConcurrent.getExecutions()) {
                            InterpretableExecution childInterpretableExecution = (InterpretableExecution)activityExecution;
                            concurrentRoot.getExecutions().add(activityExecution);
                            childInterpretableExecution.setParent(concurrentRoot);
                        }
                        lastConcurrent.getExecutions().clear();
                    }
                    concurrentRoot.setVariablesLocal(lastConcurrent.getVariablesLocal());
                    if (!concurrentRoot.isActive() && lastConcurrent.isActive()) {
                        concurrentRoot.setActive(true);
                    }
                    lastConcurrent.remove();
                } else {
                    lastConcurrent.setConcurrent(false);
                }
            }
        }
    }

    protected boolean isExecutionAloneInParent(InterpretableExecution execution) {
        ScopeImpl parentScope = (ScopeImpl)execution.getActivity().getParent();
        for (InterpretableExecution interpretableExecution : execution.getParent().getExecutions()) {
            if (interpretableExecution == execution || !parentScope.contains((ActivityImpl)interpretableExecution.getActivity())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCanonicalName() {
        return "activity-end";
    }
}

