/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessDefinitionEntity
extends ProcessDefinitionImpl
implements ProcessDefinition,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String key;
    protected int revision = 1;
    protected int version;
    protected String category;
    protected String deploymentId;
    protected String resourceName;
    protected Integer historyLevel;
    protected StartFormHandler startFormHandler;
    protected String diagramResourceName;
    protected boolean isGraphicalNotationDefined;
    protected Map<String, TaskDefinition> taskDefinitions;
    protected boolean hasStartFormKey;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected boolean isIdentityLinksInitialized = false;
    protected List<IdentityLinkEntity> definitionIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected Set<Expression> candidateStarterUserIdExpressions = new HashSet<Expression>();
    protected Set<Expression> candidateStarterGroupIdExpressions = new HashSet<Expression>();

    public ProcessDefinitionEntity() {
        super(null);
    }

    protected void ensureNotSuspended() {
        if (this.isSuspended()) {
            throw new SuspendedEntityInteractionException("Process definition " + this.id + " is suspended.");
        }
    }

    public ExecutionEntity createProcessInstance(String businessKey, ActivityImpl initial) {
        ProcessEngineConfigurationImpl configuration;
        int historyLevel;
        this.ensureNotSuspended();
        ExecutionEntity processInstance = null;
        processInstance = initial == null ? (ExecutionEntity)super.createProcessInstance() : (ExecutionEntity)super.createProcessInstanceForInitial(initial);
        processInstance.setExecutions(new ArrayList<ExecutionEntity>());
        processInstance.setProcessDefinition(this.processDefinition);
        if (businessKey != null) {
            processInstance.setBusinessKey(businessKey);
        }
        processInstance.setProcessInstance(processInstance);
        String initiatorVariableName = (String)this.getProperty("initiatorVariableName");
        if (initiatorVariableName != null) {
            String authenticatedUserId = Context.getCommandContext().getAuthenticatedUserId();
            processInstance.setVariable(initiatorVariableName, authenticatedUserId);
        }
        if ((historyLevel = (configuration = Context.getProcessEngineConfiguration()).getHistoryLevel()) >= 1) {
            HistoryEventProducer eventFactory = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent pise = eventFactory.createProcessInstanceStartEvt(processInstance);
            eventHandler.handleEvent(pise);
        }
        return processInstance;
    }

    public ExecutionEntity createProcessInstance(String businessKey) {
        return this.createProcessInstance(businessKey, null);
    }

    @Override
    public ExecutionEntity createProcessInstance() {
        return this.createProcessInstance(null);
    }

    @Override
    protected InterpretableExecution newProcessInstance(ActivityImpl activityImpl) {
        ExecutionEntity processInstance = new ExecutionEntity(activityImpl);
        processInstance.insert();
        return processInstance;
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = IdentityLinkEntity.createAndInsert();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessDef(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkManager().findIdentityLinkByProcessDefinitionUserAndGroup(this.id, userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            Context.getCommandContext().getDbSqlSession().delete(identityLink);
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.definitionIdentityLinkEntities = Context.getCommandContext().getIdentityLinkManager().findIdentityLinksByProcessDefinitionId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.definitionIdentityLinkEntities;
    }

    @Override
    public String toString() {
        return "ProcessDefinitionEntity[" + this.id + "]";
    }

    public void updateModifiedFieldsFromEntity(ProcessDefinitionEntity updatingProcessDefinition) {
        if (!this.key.equals(updatingProcessDefinition.key) || !this.deploymentId.equals(updatingProcessDefinition.deploymentId)) {
            throw new ProcessEngineException("Cannot update entity from an unrelated process definition");
        }
        this.revision = updatingProcessDefinition.revision;
        this.suspensionState = updatingProcessDefinition.suspensionState;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Integer> persistentState = new HashMap<String, Integer>();
        persistentState.put("suspensionState", this.suspensionState);
        return persistentState;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty("documentation");
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(Integer historyLevel) {
        this.historyLevel = historyLevel;
    }

    public StartFormHandler getStartFormHandler() {
        return this.startFormHandler;
    }

    public void setStartFormHandler(StartFormHandler startFormHandler) {
        this.startFormHandler = startFormHandler;
    }

    public Map<String, TaskDefinition> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void setTaskDefinitions(Map<String, TaskDefinition> taskDefinitions) {
        this.taskDefinitions = taskDefinitions;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getDiagramResourceName() {
        return this.diagramResourceName;
    }

    public void setDiagramResourceName(String diagramResourceName) {
        this.diagramResourceName = diagramResourceName;
    }

    @Override
    public boolean hasStartFormKey() {
        return this.hasStartFormKey;
    }

    public boolean getHasStartFormKey() {
        return this.hasStartFormKey;
    }

    public void setStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public void setHasStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public boolean isGraphicalNotationDefined() {
        return this.isGraphicalNotationDefined;
    }

    public void setGraphicalNotationDefined(boolean isGraphicalNotationDefined) {
        this.isGraphicalNotationDefined = isGraphicalNotationDefined;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    public Set<Expression> getCandidateStarterUserIdExpressions() {
        return this.candidateStarterUserIdExpressions;
    }

    public void addCandidateStarterUserIdExpression(Expression userId) {
        this.candidateStarterUserIdExpressions.add(userId);
    }

    public Set<Expression> getCandidateStarterGroupIdExpressions() {
        return this.candidateStarterGroupIdExpressions;
    }

    public void addCandidateStarterGroupIdExpression(Expression groupId) {
        this.candidateStarterGroupIdExpressions.add(groupId);
    }
}

