/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.MessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ActivityInstanceState;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionStartContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoryAwareStartContext;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableScopeImpl;
import org.camunda.bpm.engine.impl.persistence.entity.util.FormPropertyStartContext;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessElement;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.OutgoingExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.util.BitMaskUtil;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ExecutionEntity
extends VariableScopeImpl
implements ActivityExecution,
ExecutionListenerExecution,
Execution,
PvmExecution,
ProcessInstance,
InterpretableExecution,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecutionEntity.class.getName());
    public static final int EVENT_SUBSCRIPTIONS_STATE_BIT = 1;
    public static final int TASKS_STATE_BIT = 2;
    public static final int JOBS_STATE_BIT = 3;
    public static final int INCIDENT_STATE_BIT = 4;
    public static final int VARIABLES_STATE_BIT = 5;
    public static final int SUB_PROCESS_INSTANCE_STATE_BIT = 6;
    protected transient ProcessDefinitionImpl processDefinition;
    protected transient ActivityImpl activity;
    protected transient TransitionImpl transition = null;
    protected transient TransitionImpl transitionBeingTaken = null;
    protected transient ExecutionEntity processInstance;
    protected transient ExecutionEntity parent;
    protected transient List<ExecutionEntity> executions;
    protected transient ExecutionEntity superExecution;
    protected transient ExecutionEntity subProcessInstance;
    protected String activityInstanceId;
    protected transient ProcessInstanceStartContext processInstanceStartContext;
    protected transient ExecutionStartContext executionStartContext;
    protected boolean shouldQueryForSubprocessInstance = false;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected int activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    protected String eventName;
    protected transient PvmProcessElement eventSource;
    protected int executionListenerIndex = 0;
    protected transient List<EventSubscriptionEntity> eventSubscriptions;
    protected transient List<JobEntity> jobs;
    protected transient List<TaskEntity> tasks;
    protected transient List<IncidentEntity> incidents;
    protected int cachedEntityState;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected transient ExecutionEntity replacedBy;
    protected transient AtomicOperation nextOperation;
    protected boolean isOperating = false;
    protected int revision = 1;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String processDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String processInstanceId;
    protected String businessKey;
    protected String parentId;
    protected String superExecutionId;
    protected boolean forcedUpdate;
    protected transient PvmActivity nextActivity;

    public ExecutionEntity() {
    }

    public ExecutionEntity(ActivityImpl activityImpl) {
        this.processInstanceStartContext = new HistoryAwareStartContext(activityImpl);
    }

    @Override
    public ExecutionEntity createExecution() {
        return this.createExecution(false);
    }

    @Override
    public ExecutionEntity createExecution(boolean initializeExecutionStartContext) {
        ExecutionEntity createdExecution = this.newExecution();
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        createdExecution.activityInstanceId = this.activityInstanceId;
        if (initializeExecutionStartContext) {
            createdExecution.executionStartContext = new ExecutionStartContext();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Child execution " + createdExecution + " created with parent " + this);
        }
        return createdExecution;
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        ProcessEngineConfigurationImpl configuration;
        int historyLevel;
        ExecutionEntity subProcessInstance = this.newExecution();
        this.shouldQueryForSubprocessInstance = true;
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(subProcessInstance.getScopeActivity())) {
            declaration.createSubscription(subProcessInstance);
        }
        List timerDeclarations = (List)processDefinition.getProperty("timerDeclarations");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                timerDeclaration.createTimerInstance(subProcessInstance);
            }
        }
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        if ((historyLevel = (configuration = Context.getProcessEngineConfiguration()).getHistoryLevel()) >= 1) {
            HistoryEventProducer eventFactory = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent hpise = eventFactory.createProcessInstanceStartEvt(subProcessInstance);
            eventHandler.handleEvent(hpise);
            HistoryEvent haie = eventFactory.createActivityInstanceUpdateEvt(this, null);
            eventHandler.handleEvent(haie);
        }
        return subProcessInstance;
    }

    protected ExecutionEntity newExecution() {
        ExecutionEntity newExecution = new ExecutionEntity();
        this.initializeAssociations(newExecution);
        Context.getCommandContext().getDbSqlSession().insert(newExecution);
        return newExecution;
    }

    @Override
    public void initialize() {
        log.fine("initializing " + this);
        ScopeImpl scope = this.getScopeActivity();
        this.ensureParentInitialized();
        List variableDeclarations = (List)scope.getProperty("variableDeclarations");
        if (variableDeclarations != null) {
            for (VariableDeclaration variableDeclaration : variableDeclarations) {
                variableDeclaration.initialize(this, this.parent);
            }
        }
        this.initializeAssociations(this);
        List timerDeclarations = (List)scope.getProperty("timerDeclarations");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                timerDeclaration.createTimerInstance(this);
            }
        }
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(scope)) {
            declaration.createSubscription(this);
        }
    }

    protected void initializeAssociations(ExecutionEntity execution) {
        execution.executions = new ArrayList<ExecutionEntity>();
        execution.variableInstances = new HashMap();
        execution.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        execution.jobs = new ArrayList<JobEntity>();
        execution.tasks = new ArrayList<TaskEntity>();
        execution.incidents = new ArrayList<IncidentEntity>();
        execution.cachedEntityState = 0;
    }

    @Override
    public void start() {
        this.start(null, null);
    }

    @Override
    public void start(Map<String, Object> variables) {
        this.start(null, variables);
    }

    @Override
    public void start(String businessKey) {
        this.start(businessKey, null);
    }

    @Override
    public void start(String businessKey, Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(variables);
        }
        if (businessKey != null) {
            this.setBusinessKey(businessKey);
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    public void startWithFormProperties(Map<String, Object> properties) {
        if (this.isProcessInstance()) {
            ActivityImpl initial = this.processDefinition.getInitial();
            if (this.processInstanceStartContext != null) {
                initial = this.processInstanceStartContext.getInitial();
            }
            FormPropertyStartContext formPropertyStartContext = new FormPropertyStartContext(initial);
            formPropertyStartContext.setFormProperties(properties);
            this.processInstanceStartContext = formPropertyStartContext;
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    @Override
    public void destroy() {
        log.fine("destroying " + this);
        this.ensureParentInitialized();
        this.deleteVariablesInstanceForLeavingScope();
        this.setScope(false);
    }

    @Override
    public void cancelScope(String reason) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("performing cancel scope behavior for execution " + this);
        }
        if (this.getSubProcessInstance() != null) {
            this.getSubProcessInstance().deleteCascade(reason);
        }
        ArrayList<ExecutionEntity> executions = new ArrayList<ExecutionEntity>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : executions) {
            if (interpretableExecution.getSubProcessInstance() != null) {
                interpretableExecution.getSubProcessInstance().deleteCascade(reason);
            }
            interpretableExecution.deleteCascade(reason);
        }
        this.setCanceled(true);
        this.removeTasks(reason);
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            this.performOperation(AtomicOperation.FIRE_ACTIVITY_END);
        }
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public void end(boolean completeScope) {
        this.setCompleteScope(completeScope);
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(AtomicOperation.ACTIVITY_END);
    }

    @Override
    public void signal(String signalName, Object signalData) {
        this.ensureActivityInitialized();
        if (this.activity == null) {
            throw new PvmException("cannot signal execution " + this.id + ": it has no current activity");
        }
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition) {
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        this.setActivity((ActivityImpl)transition.getSource());
        this.setTransition((TransitionImpl)transition);
        this.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        if (activity.isConcurrent()) {
            this.nextActivity = activity;
            this.performOperation(AtomicOperation.ACTIVITY_START_CONCURRENT);
        } else if (activity.isCancelScope()) {
            this.nextActivity = activity;
            this.performOperation(AtomicOperation.ACTIVITY_START_CANCEL_SCOPE);
        } else {
            this.setActivity((ActivityImpl)activity);
            this.performOperation(AtomicOperation.ACTIVITY_START);
        }
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<ActivityExecution> otherConcurrentExecutions = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            List<ExecutionEntity> concurrentExecutions = this.getParent().getAllChildExecutions();
            for (ActivityExecution activityExecution : concurrentExecutions) {
                if (activityExecution.getActivity() == activity) {
                    if (activityExecution.isActive()) continue;
                    inactiveConcurrentExecutionsInActivity.add(activityExecution);
                    continue;
                }
                otherConcurrentExecutions.add(activityExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("inactive concurrent executions in '" + activity + "': " + inactiveConcurrentExecutionsInActivity);
            log.fine("other concurrent executions: " + otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<ExecutionEntity> getAllChildExecutions() {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity childExecution : this.getExecutions()) {
            childExecutions.add(childExecution);
            childExecutions.addAll(childExecution.getAllChildExecutions());
        }
        return childExecutions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> transitions, List<ActivityExecution> recyclableExecutions) {
        transitions = new ArrayList<PvmTransition>(transitions);
        List<ActivityExecution> list = recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (ActivityExecution recyclableExecution : recyclableExecutions) {
                if (!recyclableExecution.isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        ExecutionEntity concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<ExecutionEntity> concurrentActiveExecutions = new ArrayList<ExecutionEntity>();
        ArrayList<ExecutionEntity> concurrentInActiveExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : concurrentRoot.getExecutions()) {
            if (execution.isActive()) {
                concurrentActiveExecutions.add(execution);
                continue;
            }
            concurrentInActiveExecutions.add(execution);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("transitions to take concurrent: " + transitions);
            log.fine("active concurrent executions: " + concurrentActiveExecutions);
        }
        if (transitions.size() == 1 && concurrentActiveExecutions.isEmpty() && this.allExecutionsInSameActivity(concurrentInActiveExecutions)) {
            List<ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            recyclableExecutions.remove(concurrentRoot);
            for (ExecutionEntity executionEntity : recyclableExecutionImpls) {
                if (executionEntity.isEnded()) continue;
                log.fine("pruning execution " + executionEntity);
                executionEntity.end(false);
            }
            log.fine("activating the concurrent root " + concurrentRoot + " as the single path of execution going forward");
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(this.hasConcurrentSiblings(concurrentRoot));
            concurrentRoot.take(transitions.get(0));
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            log.fine("recyclable executions for reuse: " + recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var8_10;
                PvmTransition outgoingTransition = transitions.remove(0);
                Object var8_11 = null;
                if (recyclableExecutions.isEmpty()) {
                    ExecutionEntity executionEntity = concurrentRoot.createExecution();
                    log.fine("new " + executionEntity + " with parent " + executionEntity.getParent() + " created to take transition " + outgoingTransition);
                } else {
                    ExecutionEntity executionEntity = (ExecutionEntity)recyclableExecutions.remove(0);
                    log.fine("recycled " + executionEntity + " to take transition " + outgoingTransition);
                }
                var8_10.setActive(true);
                var8_10.setScope(false);
                var8_10.setConcurrent(true);
                var8_10.setTransitionBeingTaken((TransitionImpl)outgoingTransition);
                outgoingExecutions.add(new OutgoingExecution((InterpretableExecution)var8_10, outgoingTransition, true));
            }
            concurrentRoot.setActivityInstanceId(concurrentRoot.getParentActivityInstanceId());
            boolean isConcurrentEnd = outgoingExecutions.isEmpty();
            for (ActivityExecution prunedExecution : recyclableExecutions) {
                log.fine("pruning execution " + prunedExecution);
                prunedExecution.end(isConcurrentEnd);
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
            if (isConcurrentEnd) {
                concurrentRoot.end(true);
            }
        }
    }

    protected boolean hasConcurrentSiblings(ExecutionEntity concurrentRoot) {
        if (concurrentRoot.isProcessInstance()) {
            return false;
        }
        List<ExecutionEntity> executions = concurrentRoot.getParent().getExecutions();
        for (ExecutionEntity executionImpl : executions) {
            if (executionImpl == concurrentRoot || executionImpl.isEventScope()) continue;
            return true;
        }
        return false;
    }

    protected boolean allExecutionsInSameActivity(List<ExecutionEntity> executions) {
        if (executions.size() > 1) {
            String activityId = executions.get(0).getActivityId();
            for (ExecutionEntity execution : executions) {
                String otherActivityId = execution.getActivityId();
                if (execution.isEnded || !(activityId == null && otherActivityId != null || activityId != null && otherActivityId == null) && (activityId == null || otherActivityId == null || otherActivityId.equals(activityId))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void performOperation(AtomicOperation executionOperation) {
        if (executionOperation.isAsync(this)) {
            this.scheduleAtomicOperationAsync(executionOperation);
        } else {
            this.performOperationSync(executionOperation);
        }
    }

    @Override
    public void performOperationSync(AtomicOperation executionOperation) {
        if (this.requiresUnsuspendedExecution(executionOperation)) {
            this.ensureNotSuspended();
        }
        Context.getCommandContext().performOperation(executionOperation, this);
    }

    protected void ensureNotSuspended() {
        if (this.isSuspended()) {
            throw new SuspendedEntityInteractionException("Execution " + this.id + " is suspended.");
        }
    }

    protected boolean requiresUnsuspendedExecution(AtomicOperation executionOperation) {
        return executionOperation != AtomicOperation.TRANSITION_NOTIFY_LISTENER_END && executionOperation != AtomicOperation.TRANSITION_DESTROY_SCOPE && executionOperation != AtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE && executionOperation != AtomicOperation.TRANSITION_NOTIFY_LISTENER_END && executionOperation != AtomicOperation.TRANSITION_CREATE_SCOPE && executionOperation != AtomicOperation.TRANSITION_NOTIFY_LISTENER_START && executionOperation != AtomicOperation.DELETE_CASCADE && executionOperation != AtomicOperation.DELETE_CASCADE_FIRE_ACTIVITY_END;
    }

    protected void scheduleAtomicOperationAsync(AtomicOperation executionOperation) {
        MessageJobDeclaration messageJobDeclaration = (MessageJobDeclaration)this.getActivity().getProperty("messageJobDeclaration");
        if (messageJobDeclaration == null) {
            throw new ProcessEngineException("Asynchronous continuation requires a message job declaration.");
        }
        MessageEntity message = (MessageEntity)messageJobDeclaration.createJobInstance(this);
        message.setJobHandlerConfiguration(executionOperation.getCanonicalName());
        Context.getCommandContext().getJobManager().send(message);
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public List<ExecutionEntity> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.executions = Context.getCommandContext().getExecutionManager().findChildExecutionsByParentExecutionId(this.id);
            }
        }
    }

    protected boolean isExecutionTreePrefetchEnabled() {
        return Context.getProcessEngineConfiguration().isExecutionTreePrefetchEnabled();
    }

    public void setExecutions(List<ExecutionEntity> executions) {
        this.executions = executions;
    }

    @Override
    public ExecutionEntity findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (ExecutionEntity nestedExecution : this.getExecutions()) {
            ExecutionEntity result = nestedExecution.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        this.ensureActivityInitialized();
        if (this.isActive && this.activity != null) {
            activeActivityIds.add(this.activity.getId());
        }
        this.ensureExecutionsInitialized();
        for (ExecutionEntity execution : this.executions) {
            execution.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    protected void ensureProcessDefinitionInitialized() {
        if (this.processDefinition == null && this.processDefinitionId != null) {
            ProcessDefinitionEntity deployedProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.setProcessDefinition(deployedProcessDefinition);
        }
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.processDefinitionId = processDefinition.getId();
    }

    public ExecutionEntity getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.processInstance = Context.getCommandContext().getExecutionManager().findExecutionById(this.processInstanceId);
            }
        }
    }

    @Override
    public void setProcessInstance(InterpretableExecution processInstance) {
        this.processInstance = (ExecutionEntity)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstance() {
        return this.parentId == null;
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return this.activity;
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getProcessDefinition().findActivity(this.activityId));
        }
    }

    @Override
    public void setActivity(PvmActivity activity) {
        this.activity = (ActivityImpl)activity;
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = (String)activity.getProperty("name");
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    @Override
    public void enterActivityInstance() {
        ActivityImpl activity = this.getActivity();
        if (activity == null && this.processInstanceStartContext != null) {
            activity = this.processInstanceStartContext.getInitial();
        }
        this.activityInstanceId = this.generateActivityInstanceId(activity.getId());
        if (log.isLoggable(Level.FINE)) {
            log.fine("[ENTER] " + this + ": " + this.activityInstanceId + ", parent: " + this.getParentActivityInstanceId());
        }
    }

    @Override
    public void leaveActivityInstance() {
        if (this.activityInstanceId != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[LEAVE] " + this + ": " + this.activityInstanceId);
            }
            this.activityInstanceId = this.getParentActivityInstanceId();
        }
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isProcessInstance()) {
            return this.id;
        }
        ExecutionEntity parent = this.getParent();
        ActivityImpl activity = this.getActivity();
        ActivityImpl parentActivity = parent.getActivity();
        if (parent.isScope() && !this.isConcurrent() || parent.isConcurrent && activity != parentActivity) {
            return parent.getActivityInstanceId();
        }
        return parent.getParentActivityInstanceId();
    }

    protected String generateActivityInstanceId(String activityId) {
        if (activityId.equals(this.processDefinitionId)) {
            return this.processInstanceId;
        }
        String nextId = Context.getProcessEngineConfiguration().getIdGenerator().getNextId();
        String compositeId = activityId + ":" + nextId;
        if (compositeId.length() > 64) {
            return String.valueOf(nextId);
        }
        return compositeId;
    }

    public void forceUpdateActivityInstance() {
        this.activityInstanceId = this.generateActivityInstanceId(this.getActivity().getActivityId());
    }

    @Override
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public ExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.parent = Context.getCommandContext().getExecutionManager().findExecutionById(this.parentId);
            }
        }
    }

    @Override
    public void setParent(InterpretableExecution parent) {
        this.parent = (ExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        this.superExecutionId = superExecution != null ? superExecution.getId() : null;
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(InterpretableExecution subProcessInstance) {
        this.shouldQueryForSubprocessInstance = subProcessInstance != null;
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.shouldQueryForSubprocessInstance && this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    protected ScopeImpl getScopeActivity() {
        ScopeImpl scope = null;
        scope = this.isProcessInstance() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void remove() {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.ensureExecutionsInitialized();
            this.parent.executions.remove(this);
        }
        this.isEnded = true;
        this.ensureVariableInstancesInitialized();
        this.deleteVariablesInstanceForLeavingScope();
        this.removeTasks(null);
        this.removeJobs();
        this.removeIncidents();
        this.removeEventSubscriptions();
        this.removeEventScopes();
        Context.getCommandContext().getDbSqlSession().delete(this);
    }

    @Override
    public void interruptScope(String reason) {
        this.removeJobs();
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptions();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if ("compensate".equals(eventSubscriptionEntity.getEventType())) continue;
            eventSubscriptionEntity.delete();
        }
    }

    private void removeEventScopes() {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : childExecutions) {
            if (!interpretableExecution.isEventScope()) continue;
            log.fine("removing eventScope " + interpretableExecution);
            interpretableExecution.destroy();
            interpretableExecution.remove();
        }
    }

    public void removeEventSubscriptions() {
        for (EventSubscriptionEntity eventSubscription : this.getEventSubscriptions()) {
            if (this.replacedBy != null) {
                eventSubscription.setExecution(this.replacedBy);
                continue;
            }
            eventSubscription.delete();
        }
    }

    private void removeJobs() {
        for (JobEntity job : this.getJobs()) {
            if (this.replacedBy != null) {
                job.setExecution(this.replacedBy);
                continue;
            }
            job.delete();
        }
    }

    private void removeIncidents() {
        for (IncidentEntity incident : this.getIncidents()) {
            if (this.replacedBy != null) {
                incident.setExecution(this.replacedBy);
                continue;
            }
            incident.delete();
        }
    }

    private void removeTasks(String reason) {
        if (reason == null) {
            reason = "deleted";
        }
        for (TaskEntity task : this.getTasks()) {
            if (this.replacedBy != null) {
                if (task.getExecution() != null && task.getExecution() == this.replacedBy) continue;
                task.setExecution(this.replacedBy);
                this.replacedBy.addTask(task);
                continue;
            }
            task.delete(reason, false);
        }
    }

    @Override
    public ExecutionEntity getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(InterpretableExecution replacedBy) {
        this.replacedBy = (ExecutionEntity)replacedBy;
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        for (TaskEntity task : this.getTasks()) {
            task.setExecutionId(replacedBy.getId());
            task.setExecution(this.replacedBy);
            List<VariableInstanceEntity> variables = commandContext.getVariableInstanceManager().findVariableInstancesByTaskId(task.getId());
            for (VariableInstanceEntity variable : variables) {
                variable.setExecution(this.replacedBy);
            }
            this.replacedBy.addTask(task);
        }
        this.tasks.clear();
        List<TaskEntity> tasks = dbSqlSession.findInCache(TaskEntity.class);
        for (TaskEntity task : tasks) {
            if (!this.id.equals(task.getExecutionId())) continue;
            task.setExecutionId(replacedBy.getId());
        }
        List<JobEntity> jobs = this.getJobs();
        for (JobEntity job : jobs) {
            job.setExecution((ExecutionEntity)replacedBy);
        }
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptions();
        for (EventSubscriptionEntity subscriptionEntity : eventSubscriptions) {
            subscriptionEntity.setExecution((ExecutionEntity)replacedBy);
        }
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variable : this.variableInstances.values()) {
            variable.setExecutionId(replacedBy.getId());
        }
        replacedBy.setActivityInstanceId(this.activityInstanceId);
    }

    @Override
    public void replace(InterpretableExecution execution) {
        ExecutionEntity replacedExecution = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        for (TaskEntity task : replacedExecution.getTasksInternal()) {
            task.setExecutionId(this.getId());
            task.setExecution(this);
            List<VariableInstanceEntity> variables = commandContext.getVariableInstanceManager().findVariableInstancesByTaskId(task.getId());
            for (VariableInstanceEntity variable : variables) {
                variable.setExecution(this);
            }
            this.addTask(task);
        }
        replacedExecution.getTasksInternal().clear();
        this.activityInstanceId = execution.getActivityInstanceId();
        execution.leaveActivityInstance();
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setProcessInstanceId(this.processInstanceId);
        variableInstance.setExecutionId(this.id);
    }

    @Override
    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByExecutionId(this.id);
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    @Override
    protected boolean isAutoFireHistoryEvents() {
        return this.processInstanceStartContext == null && this.executionStartContext == null;
    }

    public void fireHistoricVariableInstanceCreateEvents() {
        if (this.variableInstances != null) {
            for (Map.Entry variable : this.variableInstances.entrySet()) {
                this.fireHistoricVariableInstanceCreate((VariableInstanceEntity)variable.getValue(), this);
            }
        }
    }

    protected void ensureExecutionTreeInitialized() {
        List<ExecutionEntity> executions = Context.getCommandContext().getExecutionManager().findChildExecutionsByProcessInstanceId(this.processInstanceId);
        ExecutionEntity processInstance = null;
        HashMap<String, ExecutionEntity> executionMap = new HashMap<String, ExecutionEntity>();
        for (ExecutionEntity execution : executions) {
            execution.executions = new ArrayList<ExecutionEntity>();
            executionMap.put(execution.getId(), execution);
            if (!execution.isProcessInstance()) continue;
            processInstance = execution;
        }
        for (ExecutionEntity execution : executions) {
            String parentId = execution.getParentId();
            ExecutionEntity parent = (ExecutionEntity)executionMap.get(parentId);
            if (!execution.isProcessInstance()) {
                execution.processInstance = processInstance;
                execution.parent = parent;
                parent.executions.add(execution);
                continue;
            }
            execution.processInstance = execution;
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("activityInstanceId", this.activityInstanceId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("superExecution", this.superExecutionId);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("cachedEntityState", this.getCachedEntityState());
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.isEnded = true;
        this.performOperation(AtomicOperation.DELETE_CASCADE);
    }

    @Override
    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    public String toString() {
        if (this.isProcessInstance()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    public List<EventSubscriptionEntity> getEventSubscriptionsInternal() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    public List<EventSubscriptionEntity> getEventSubscriptions() {
        return new ArrayList<EventSubscriptionEntity>(this.getEventSubscriptionsInternal());
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions() {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity)) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions(String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionManager().findEventSubscriptionsByExecution(this.id);
        }
    }

    public void addEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        this.getEventSubscriptionsInternal().add(eventSubscriptionEntity);
    }

    public void removeEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        this.getEventSubscriptionsInternal().remove(eventSubscriptionEntity);
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null) {
            this.jobs = Context.getCommandContext().getJobManager().findJobsByExecutionId(this.id);
        }
    }

    protected List<JobEntity> getJobsInternal() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    public List<JobEntity> getJobs() {
        return new ArrayList<JobEntity>(this.getJobsInternal());
    }

    public void addJob(JobEntity jobEntity) {
        this.getJobsInternal().add(jobEntity);
    }

    public void removeJob(JobEntity job) {
        this.getJobsInternal().remove(job);
    }

    protected void ensureIncidentsInitialized() {
        if (this.incidents == null) {
            this.incidents = Context.getCommandContext().getIncidentManager().findIncidentsByExecution(this.id);
        }
    }

    protected List<IncidentEntity> getIncidentsInternal() {
        this.ensureIncidentsInitialized();
        return this.incidents;
    }

    public List<IncidentEntity> getIncidents() {
        return new ArrayList<IncidentEntity>(this.getIncidentsInternal());
    }

    public void addIncident(IncidentEntity incident) {
        this.getIncidentsInternal().add(incident);
    }

    public void removeIncident(IncidentEntity incident) {
        this.getIncidentsInternal().remove(incident);
    }

    public IncidentEntity getIncidentByCauseIncidentId(String causeIncidentId) {
        for (IncidentEntity incident : this.getIncidents()) {
            if (incident.getCauseIncidentId() == null || !incident.getCauseIncidentId().equals(causeIncidentId)) continue;
            return incident;
        }
        return null;
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskManager().findTasksByExecutionId(this.id);
        }
    }

    protected List<TaskEntity> getTasksInternal() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    public List<TaskEntity> getTasks() {
        return new ArrayList<TaskEntity>(this.getTasksInternal());
    }

    public void addTask(TaskEntity taskEntity) {
        this.getTasksInternal().add(taskEntity);
    }

    public void removeTask(TaskEntity task) {
        this.getTasksInternal().remove(task);
    }

    public void setCachedEntityState(int cachedEntityState) {
        this.cachedEntityState = cachedEntityState;
        if (this.jobs == null && !BitMaskUtil.isBitOn(cachedEntityState, 3)) {
            this.jobs = new ArrayList<JobEntity>();
        }
        if (this.tasks == null && !BitMaskUtil.isBitOn(cachedEntityState, 2)) {
            this.tasks = new ArrayList<TaskEntity>();
        }
        if (this.eventSubscriptions == null && !BitMaskUtil.isBitOn(cachedEntityState, 1)) {
            this.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        }
        if (this.incidents == null && !BitMaskUtil.isBitOn(cachedEntityState, 4)) {
            this.incidents = new ArrayList<IncidentEntity>();
        }
        if (this.variableInstances == null && !BitMaskUtil.isBitOn(cachedEntityState, 5)) {
            this.variableInstances = new HashMap();
        }
        this.shouldQueryForSubprocessInstance = BitMaskUtil.isBitOn(cachedEntityState, 6);
    }

    public int getCachedEntityState() {
        this.cachedEntityState = 0;
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 2, this.tasks == null || this.tasks.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 1, this.eventSubscriptions == null || this.eventSubscriptions.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 3, this.jobs == null || this.jobs.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 4, this.incidents == null || this.incidents.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 5, this.variableInstances == null || this.variableInstances.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 6, this.shouldQueryForSubprocessInstance);
        return this.cachedEntityState;
    }

    public int getCachedEntityStateRaw() {
        return this.cachedEntityState;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    public TransitionImpl getTransitionBeingTaken() {
        return this.transitionBeingTaken;
    }

    public void setTransitionBeingTaken(TransitionImpl transitionBeingTaken) {
        this.transitionBeingTaken = transitionBeingTaken;
    }

    @Override
    public Integer getExecutionListenerIndex() {
        return this.executionListenerIndex;
    }

    @Override
    public void setExecutionListenerIndex(Integer executionListenerIndex) {
        this.executionListenerIndex = executionListenerIndex;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public boolean isCanceled() {
        return ActivityInstanceState.CANCELED.getStateCode() == this.activityInstanceState;
    }

    @Override
    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.activityInstanceState = ActivityInstanceState.CANCELED.getStateCode();
        }
    }

    @Override
    public boolean isCompleteScope() {
        return ActivityInstanceState.SCOPE_COMPLETE.getStateCode() == this.activityInstanceState;
    }

    @Override
    public void setCompleteScope(boolean completeScope) {
        if (completeScope) {
            this.activityInstanceState = ActivityInstanceState.SCOPE_COMPLETE.getStateCode();
        }
    }

    public int getActivityInstanceState() {
        return this.activityInstanceState;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public PvmProcessElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(PvmProcessElement eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        if (this.isProcessInstance() && this.processInstanceStartContext == null) {
            this.processInstanceStartContext = new ProcessInstanceStartContext(this.processDefinition.getInitial());
        }
        return this.processInstanceStartContext;
    }

    @Override
    public ExecutionStartContext getExecutionStartContext() {
        return this.executionStartContext;
    }

    @Override
    public void disposeProcessInstanceStartContext() {
        this.processInstanceStartContext = null;
    }

    @Override
    public void disposeExecutionStartContext() {
        this.executionStartContext = null;
    }

    @Override
    public String getCurrentActivityId() {
        return this.activityId;
    }

    @Override
    public String getCurrentActivityName() {
        return this.activityName;
    }

    @Override
    public String getCurrentTransitionId() {
        if (this.transition != null) {
            return this.transition.getId();
        }
        return null;
    }

    @Override
    public PvmActivity getNextActivity() {
        return this.nextActivity;
    }

    @Override
    public FlowElement getBpmnModelElementInstance() {
        BpmnModelInstance bpmnModelInstance = this.getBpmnModelInstance();
        if (bpmnModelInstance != null) {
            ModelElementInstance modelElementInstance = null;
            modelElementInstance = "take".equals(this.eventName) ? bpmnModelInstance.getModelElementById(this.transition.getId()) : bpmnModelInstance.getModelElementById(this.activityId);
            try {
                return (FlowElement)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw new ProcessEngineException("Cannot cast " + modelElementInstance + " to FlowElement. " + "Is of type " + elementType.getTypeName() + " Namespace " + elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance() {
        if (this.processDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }
}

