/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.mail;

import java.util.Map;
import org.camunda.bpm.engine.impl.cmd.GetUserAccountCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.Account;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.mail.MailScanCmd;

public class CreateMailScanCmd
implements Command<MailScanCmd> {
    protected String userId;
    protected String userPassword;

    public CreateMailScanCmd(String userId, String userPassword) {
        this.userId = userId;
        this.userPassword = userPassword;
    }

    @Override
    public MailScanCmd execute(CommandContext commandContext) {
        MailScanCmd mailScanCmd = null;
        Account account = new GetUserAccountCmd(this.userId, this.userPassword, "mailscan").execute(commandContext);
        if (account != null) {
            Map<String, String> details = account.getDetails();
            String imapUsername = account.getUsername();
            String imapPassword = account.getPassword();
            String toDoFolderName = details.get("toDoFolderName");
            String toDoInActivitiFolderName = details.get("toDoInActivitiFolderName");
            String imapHost = details.get("imapHost");
            String imapProtocol = details.get("imapProtocol");
            if (imapHost == null) {
                Map<Object, Object> beans = Context.getProcessEngineConfiguration().getBeans();
                imapHost = (String)beans.get("imapHost");
                imapProtocol = (String)beans.get("imapProtocol");
            }
            mailScanCmd = new MailScanCmd();
            mailScanCmd.setUserId(this.userId);
            mailScanCmd.setImapUsername(imapUsername);
            mailScanCmd.setImapPassword(imapPassword);
            mailScanCmd.setImapHost(imapHost);
            mailScanCmd.setImapProtocol(imapProtocol);
            mailScanCmd.setToDoFolderName(toDoFolderName);
            mailScanCmd.setToDoInActivitiFolderName(toDoInActivitiFolderName);
        }
        return mailScanCmd;
    }
}

