/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public abstract class JobDeclaration<T extends JobEntity>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String jobDefinitionId;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration;
    protected String jobConfiguration;
    protected boolean exclusive = true;
    protected int retries = 3;
    protected String activityId;

    public JobDeclaration(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public T createJobInstance(ExecutionEntity execution) {
        JobDefinitionEntity jobDefinition;
        T job = this.newJobInstance(execution);
        ((JobEntity)job).setJobDefinitionId(this.jobDefinitionId);
        if (this.jobDefinitionId != null && (jobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(this.jobDefinitionId)) != null) {
            ((JobEntity)job).setSuspensionState(jobDefinition.getSuspensionState());
            ((JobEntity)job).setProcessDefinitionKey(jobDefinition.getProcessDefinitionKey());
            ((JobEntity)job).setProcessDefinitionId(jobDefinition.getProcessDefinitionId());
        }
        ((JobEntity)job).setJobHandlerType(this.jobHandlerType);
        ((JobEntity)job).setJobHandlerConfiguration(this.jobHandlerConfiguration);
        ((JobEntity)job).setExclusive(this.exclusive);
        ((JobEntity)job).setRetries(this.retries);
        return job;
    }

    protected abstract T newJobInstance(ExecutionEntity var1);

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }
}

