/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;

public class AsyncContinuationJobHandler
implements JobHandler {
    public static final String TYPE = "async-continuation";
    private Map<String, AtomicOperation> supportedOperations = new HashMap<String, AtomicOperation>();

    public AsyncContinuationJobHandler() {
        this.supportedOperations.put(AtomicOperation.TRANSITION_CREATE_SCOPE.getCanonicalName(), AtomicOperation.TRANSITION_CREATE_SCOPE);
        this.supportedOperations.put(AtomicOperation.PROCESS_START.getCanonicalName(), AtomicOperation.PROCESS_START);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext) {
        AtomicOperation atomicOperation = this.findMatchingAtomicOperation(configuration);
        if (atomicOperation == null) {
            throw new ProcessEngineException("Cannot process job with configuration " + configuration);
        }
        commandContext.performOperation(atomicOperation, execution);
    }

    protected AtomicOperation findMatchingAtomicOperation(String configuration) {
        if (configuration == null) {
            return AtomicOperation.TRANSITION_CREATE_SCOPE;
        }
        return this.supportedOperations.get(configuration);
    }
}

