/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.type;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;

public class EnumFormType
extends AbstractFormFieldType {
    public static final String TYPE_NAME = "enum";
    protected Map<String, String> values;

    public EnumFormType(Map<String, String> values) {
        this.values = values;
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    @Override
    public Object getInformation(String key) {
        if (key.equals("values")) {
            return this.values;
        }
        return null;
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        this.validateValue(propertyValue);
        return propertyValue;
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue != null) {
            if (!(modelValue instanceof String)) {
                throw new ProcessEngineException("Model value should be a String");
            }
            this.validateValue((String)modelValue);
        }
        return (String)modelValue;
    }

    protected void validateValue(Object value) {
        if (value != null && this.values != null && !this.values.containsKey(value)) {
            throw new ProcessEngineException("Invalid value for enum form property: " + value);
        }
    }

    public Map<String, String> getValues() {
        return this.values;
    }
}

