/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class SetExecutionVariablesCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String executionId;
    protected Map<String, ? extends Object> variables;
    protected boolean isLocal;

    public SetExecutionVariablesCmd(String executionId, Map<String, ? extends Object> variables, boolean isLocal) {
        this.executionId = executionId;
        this.variables = variables;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ProcessEngineException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ProcessEngineException("execution " + this.executionId + " doesn't exist");
        }
        if (this.isLocal) {
            execution.setVariablesLocal(this.variables);
        } else {
            execution.setVariables(this.variables);
        }
        return null;
    }
}

