/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class RemoveExecutionVariablesCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String executionId;
    private Collection<String> variableNames;
    private boolean isLocal;

    public RemoveExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ProcessEngineException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ProcessEngineException("execution " + this.executionId + " doesn't exist");
        }
        if (this.isLocal) {
            execution.removeVariablesLocal(this.variableNames);
        } else {
            execution.removeVariables(this.variableNames);
        }
        return null;
    }
}

